/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

#include "Config_Parser.hh"
#include <iostream>
#include <string>
#include <sstream>

using namespace XBobble;

int
main()
{
	Config_Lexer lexer(std::cin);
	Token t;
	int stmt_num = 1;
	bool quit = false;

	do {
		t = lexer.next();

		switch(t) {
		case ASSIGNMENT_TOKEN:
			std::cout << " assignment ";
			break;

		case END_STATEMENT_TOKEN:
			std::cout << " end-statement\n";
			++stmt_num;
			break;

		case STRING_TOKEN:
			std::cout << " string(" << lexer.get_last_string() << ") ";
			break;

		case UNKNOWN_TOKEN:
			std::cout << "unknown-token(stmt " << stmt_num
				  << ", line " << lexer.get_line_num() << ") ";
			break;

		case EOF_TOKEN:
			std::cout << " eof\n";
			quit = true;
			// carry on.....

		default:
			break;

		} // switch(t)

	} while(!quit && lexer.istream_ok());

	return 0;
}

