/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

#include "Config_Parser.hh"
#include <iostream>
#include <iomanip>
#include <map>
#include <string>
#include <sstream>
#include <fstream>
#include <iterator>
#include <algorithm>
#include <cstdlib>

using namespace XBobble;

int
main(int argc, char** argv)
{
	Config_Parser parser;
	Config_Parser::Symtab symtab;

	char* envtmp = std::getenv("TESTCONFIG_PARSER");
	std::string envstring = (envtmp != 0) ? envtmp : "";
	std::istringstream env_istream(envstring);

	std::cout << "Processing environment variable TESTCONFIG_PARSER\n";
	parser.process(env_istream, std::cout, symtab);
	std::cout << "Done! " << parser.get_lexer().get_line_num()
		  << " lines processed, " << parser.get_lexer().get_stmt_num()
		  << " statements processed.\n";

	if(argc != 1) {
		std::cout << "Processing input file\n";
		std::istream* ssin;
		std::ifstream fin;
		if(std::string(argv[1]) == "-")
			ssin = &std::cin;
		else {
			fin.open(argv[1]);
			ssin = &fin;
		}
		if(!ssin->good()) {
			std::cout << "Error parsing stream " << argv[1]
				  << std::endl;
		} else {
			parser.process(*ssin, std::cout, symtab);
			std::cout << "Done! "
				  << parser.get_lexer().get_line_num()
				  << " lines processed, "
				  << parser.get_lexer().get_stmt_num()
				  << " statements processed.\n";
		}
	}

	std::cout << "Symtab is as follows:\n\n";

	std::cout << std::setw(30) << std::left << "First" << "Second\n";

	for(Config_Parser::Symtab::iterator it = symtab.begin(),
		    itend = symtab.end(); it != itend; ++it) {
		std::cout << std::setw(30) << std::left << it->first
			  << it->second << "\n";
	}

	return 0;
}

