/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* Basic and TOTALLY CRAP test of the XBobble::Grid class.

   Takes 3 arguments (all optional):

   number of rows (default 13)

   number of columns (default 8)

   radius of each space (default 40)

*/

#include <iostream>
#include <iomanip>
#include <stdexcept>
#include <typeinfo>
#include <cstdlib>
#include <memory>
#include <sstream>
#include <string>
#include <cmath>
#include <ctime>
#include <typeinfo>
#include <list>
#include <unistd.h>

#include <SDL.h>
#include <SDL_opengl.h>

#include <ayq/stdint.h>
#include <ayq/utils/maths/Trig_Lookup.hh>
#include <ayq/utils/time/tocks.h>

#include "Grid.hh"

using namespace XBobble;

class TestBall : public GridItemBase
{
public:
	TestBall(Grid* arg_grid)
	 : GridItemBase(arg_grid, false), is_flashing(false), is_current(false)
	{
	}

	TestBall*
	create_copy() const
	{
		return static_cast<TestBall*>(NULL);
	}

	const char*
	myname() const
	{
		return "TestBall";
	}

	bool is_flashing, is_current;
};

std::list<TestBall> balls;

SDL_Surface* screen;

std::auto_ptr<Grid> grid;

bool done = false;

bool touching_test = false;
Grid::iterator touching_current;
Grid::iterator touching_begin;
Grid::iterator touching_end;
int32_t touching_tch = GridSpace::UR;

float zoomin = 1500.0;

uint32_t scr_w = 1024, scr_h = 768;

uint32_t frameskip = 0;

GLfloat position0[] = {0, 0, 0, 0};
GLfloat colour0[] = {1, 1, 1, 1};

GLuint one_ball_dl;

bool smooth = false;

void
handle_events()
{
	SDL_Event e;
	/* Process as many events as are pending. */
	while(SDL_PollEvent(&e)) {
		switch(e.type) {
		case SDL_KEYDOWN:

			switch(e.key.keysym.sym) {
			case SDLK_ESCAPE:
				done = true;
				break;

			case SDLK_UP:
				if(e.key.keysym.mod & KMOD_SHIFT)
					zoomin -= 50;
				else
					zoomin -= 20;
				break;

			case SDLK_DOWN:
				if(e.key.keysym.mod & KMOD_SHIFT)
					zoomin += 50;
				else
					zoomin += 20;
				break;

			case SDLK_f:
				SDL_WM_ToggleFullScreen(screen);
				break;

			case SDLK_l:
				std::cout << "Light position: "
					  << position0[0] << ", "
					  << position0[1] << ", "
					  << position0[2] << '\n';
				break;

			case SDLK_s:
				if(smooth) {
					std::cout << "Flat shading\n";
					glShadeModel(GL_FLAT);
					smooth = false;
				} else {
					std::cout << "Smooth shading\n";
					glShadeModel(GL_SMOOTH);
					smooth = true;
				}
				break;

			case SDLK_t:
				// Init touching test mode
				touching_test = !touching_test;
				std::cout << "Touching test is "
					  << touching_test << '\n';
				break;

			case SDLK_KP_PLUS:
				++frameskip;
				std::cout << "Setting frameskip to "
					  << frameskip << "\n";
				break;

			case SDLK_KP_MINUS:
				--frameskip;
				std::cout << "Setting frameskip to "
					  << frameskip << "\n";
				break;

			default:
				break;
			}

			break;

		case SDL_QUIT:
			done = true;

		default:
			break;
		};
	}
}

GLuint balls_dl;

GLfloat table_radius = 0;
Grid::size_type_single table_rows = 0, table_cols = 0;
GLfloat table_width, table_height;
#define table_height (grid->h())
#define table_width (grid->w())

float
rand01()
{
	return static_cast<float>(rand())/RAND_MAX;
}

void
draw_screen()
{
	glViewport(0, 0, scr_w, scr_h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	// Note to self: These are NOT Viewport dependant!
	glFrustum(-160, 160, -120, 120, 500, 10000);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glTranslatef(0, 0, -zoomin);

	glPushMatrix();

	glRotatef(-40, 1, 0, 0);
	glTranslatef(-table_width/2.0, table_height * 0.6, -table_width/2.0);

	GLfloat front_mat_diffuse_table[] = {.3, .3, .5, 1.0};
	glMaterialfv(GL_FRONT, GL_DIFFUSE, front_mat_diffuse_table);

	// Draw table
	glBegin(GL_POLYGON); {
		glNormal3f(0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, -table_height, 0);
		glVertex3f(table_width, -table_height, 0);
		glVertex3f(table_width, 0, 0);
	}; glEnd();

	// Draw balls
	GLfloat white[]
		= {1.0, 1.0, 1.0, 1.0};
	GLfloat red[]
		= {1.0, 0.2, 0.2, 1.0};
	GLfloat green[]
		= {0.2, 1.0, 0.2, 1.0};

//	glCallList(balls_dl);
	for(Grid::iterator it = grid->begin(), itend = grid->end();
	    it != itend; ++it) {
		glPushMatrix();

		TestBall* ball = (TestBall*)it->item;
		if(ball == NULL)
			throw std::invalid_argument(" in dynamic_cast<TestBall*> in function draw_screen()");

		if(touching_test) {
			if(ball->is_current)
				glMaterialfv(GL_FRONT, GL_DIFFUSE, green);
			else if(ball->is_flashing)
				glMaterialfv(GL_FRONT, GL_DIFFUSE, red);
			else
				glMaterialfv(GL_FRONT, GL_DIFFUSE, white);
		} else {
			glMaterialfv(GL_FRONT, GL_DIFFUSE, white);
		}

		glTranslatef(it->x(), -it->y(), 0);
		glCallList(one_ball_dl);

		glPopMatrix();
	}

	glPopMatrix();

	glFlush();

	SDL_GL_SwapBuffers();
}


class AtExit
{
public:
	bool init;

	AtExit()
	 : init(false)
	{
	}

	~AtExit()
	{
		if(init)
			SDL_Quit();
	}
};

uint32_t
ayq_user_get_ticks()
{
	return SDL_GetTicks();
}

void
move_to_next_touching()
{
	((TestBall*)touching_current->item)->is_current = false;

	++touching_current;

	if(touching_current == touching_end)
		touching_current = touching_begin;

	((TestBall*)touching_current->item)->is_current = true;
}

void
flash_touching()
{
	TestBall* ball;
	if(touching_current->get_adj(touching_tch)) {
		ball = (TestBall*)touching_current->get_adj(touching_tch)->item;
		ball->is_flashing = false;
	}

	if(touching_tch == GridSpace::UR) {
		touching_tch = GridSpace::R;
		move_to_next_touching();
	} else {
		++touching_tch;
	}

	if(touching_current->get_adj(touching_tch)) {
		ball = (TestBall*)touching_current->get_adj(touching_tch)->item;
		ball->is_flashing = true;
	}
}

int32_t flash_touching_count = 1;

void
ayq_user_process_tock(uint32_t, void* user_pointer)
{
	handle_events();
	++*((uint32_t*)user_pointer); // The tock was processed.

	if(touching_test) {
		AYQ_TOCK_FUNC(flash_touching(), flash_touching_count, 10);
	}
}

#define print_SDL_GL_attr_val(attr) {int glattr; if(SDL_GL_GetAttribute(attr, &glattr) == 0) {std::cout << "SDL GL attr val " << #attr << " = " << glattr << "\n";} else {std::cout << "Error getting GL attr val for " << int(attr) << "\n";} }

int
real_main()
{
	if(SDL_Init(SDL_INIT_NOPARACHUTE|SDL_INIT_VIDEO) == -1)
		throw std::runtime_error("SDL not initialised!");

	//SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
	//SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 6);
	//SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
	//SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

	screen = SDL_SetVideoMode(scr_w, scr_h, 0,
				  SDL_HWSURFACE|SDL_OPENGL
				  |SDL_NOFRAME);

	if(!screen)
		throw std::runtime_error("OpenGL not initialised!");

	SDL_EnableKeyRepeat(250, 30);

	print_SDL_GL_attr_val(SDL_GL_RED_SIZE);
	print_SDL_GL_attr_val(SDL_GL_GREEN_SIZE);
	print_SDL_GL_attr_val(SDL_GL_BLUE_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ALPHA_SIZE);
	print_SDL_GL_attr_val(SDL_GL_DOUBLEBUFFER);
	print_SDL_GL_attr_val(SDL_GL_BUFFER_SIZE);
	print_SDL_GL_attr_val(SDL_GL_DEPTH_SIZE);
	print_SDL_GL_attr_val(SDL_GL_STENCIL_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_RED_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_GREEN_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_BLUE_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_ALPHA_SIZE);

	glShadeModel(GL_SMOOTH);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_DEPTH_TEST);
	glClearColor(0.4, 0.125, 0.125, 1.0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	/* Light 0 */
	position0[2] = zoomin;
	glLightfv(GL_LIGHT0, GL_POSITION, position0);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, colour0);

	// Display lists

	one_ball_dl = glGenLists(1);

	GLUquadric* quadric = gluNewQuadric();

	glNewList(one_ball_dl, GL_COMPILE); {
		glTranslatef(0, 0, table_radius);
		gluSphere(quadric, table_radius, 8, 5);
	}; glEndList();

	gluDeleteQuadric(quadric);

	glLoadIdentity();

// 	balls_dl = glGenLists(1);
// 	glNewList(balls_dl, GL_COMPILE);
// 	for(Grid::iterator it = grid->begin(), itend = grid->end();
// 	    it != itend; ++it) {
// 		glPushMatrix();

// 		GLfloat front_mat_diffuse_ball[]
// 			= {rand01(), rand01(), rand01(), 1.0};
// 		glMaterialfv(GL_FRONT, GL_DIFFUSE, front_mat_diffuse_ball);

// 		glTranslatef(it->x(), -it->y(), 0);
// 		glCallList(one_ball_dl);

// 		glPopMatrix();
// 	}
// 	glEndList();

	AtExit at_exit;
	at_exit.init = true;

	draw_screen();

	AYQTockData tock_data;
	ayq_init_tock_data(&tock_data, 1000/20);
	// user_pointer points back to user_data, so it can be passed
	// by reference and updated
	tock_data.user_pointer = &tock_data.user_data;

	while(!done) {
		ayq_tock_gen_basic(&tock_data);

		// frameskip
		if(tock_data.user_data  >= frameskip) {
			draw_screen();
			tock_data.user_data = 0;
		}
	}

	return 0;
}


int
main(int argc, char** argv)
{
	if(argc >= 2) {
		std::istringstream strin(argv[1]);
		strin >> table_rows;
	}

	// Set boolalpha
	std::cout << std::boolalpha;

	std::srand(std::time(NULL));

	if(argc >= 3) {
		std::istringstream strin(argv[2]);
		strin >> table_cols;
	}

	if(argc >= 4) {
		std::istringstream strin(argv[3]);
		strin >> table_radius;
	}

	if(table_rows == 0)
		table_rows = 13;

	if(table_cols == 0)
		table_cols = 8;

	if(table_radius == 0)
		table_radius = 20;

	std::cout << "Using rows/cols/radius " << table_rows << "/"
		  << table_cols << "/" << table_radius << '\n';

	grid = std::auto_ptr<Grid>(
		new Grid(table_rows, table_cols, table_radius));

	// Setup test balls
	for(Grid::iterator it = grid->begin(), itend = grid->end();
	    it != itend; ++it) {
		balls.push_back(TestBall(grid.get()));
		it->item = &balls.back();
	}

	touching_begin = grid->begin();
	touching_end = grid->end();
	touching_current = touching_end; --touching_current;
	((TestBall*)touching_current->item)->is_current = true;

	try
	{
		real_main();
	}
	catch(std::exception& e)
	{
		std::cerr << "Exception " << typeid(e).name() << ": "
			  << e.what() << std::endl;
	}
	catch(const char* c)
	{
		std::cerr << "Exception : " << c << std::endl;
	}
	catch(...)
	{
		std::cerr << "Unknown exception occured!" << std::endl;
		throw;
	}
}

