#include <iostream>
#include <stdexcept>
#include <cstdlib>
#include <ayq/stdint.h>
#include <SDL.h>
#include <SDL_opengl.h>
#include "Ball_Trait.hh"

SDL_Surface* screen;
bool done = false;
bool smooth = true;

uint32_t scr_w = 800, scr_h = 600;


float
rand01()
{
	return static_cast<float>(rand())/RAND_MAX;
}

void
resize(uint32_t w, uint32_t h)
{
	scr_w = w; scr_h = h;

	screen = SDL_SetVideoMode(scr_w, scr_h, 0,
				  SDL_HWSURFACE|SDL_OPENGL
				  |SDL_RESIZABLE);

	if(!screen)
		throw std::runtime_error("OpenGL not initialised!");

	glViewport(0, 0, scr_w, scr_h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	// Note to self: These are NOT Viewport dependant!
	glFrustum(-100, 100, -75, 75, 500, 10000);

	glMatrixMode(GL_MODELVIEW);
}


void
draw()
{
	static XBobble::Ball_Trait
		b1(1, 15, 100,
		   .0, .0, .0, 1,
		   .8, .8, .8, 1,
		   1, 1, 1, 1),
		b2(2, 15, 100,
		   .0, .0, .0, 1,
		   .8, .8, .8, 1,
		   1, 1, 1, 1),
		b3(3, 15, 100,
		   .0, .0, .0, 1,
		   .8, .8, .8, 1,
		   1, 1, 1, 1);


	glLoadIdentity();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	const GLfloat position0[] = {0, 0, 0, 1};

	glLightfv(GL_LIGHT0, GL_POSITION, position0);

	glTranslatef(0, 0, -1000);

	glPushMatrix();
	glTranslatef(0, 150, 200);
	glLightfv(GL_LIGHT0, GL_POSITION, position0);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(-150, 0, 0);
	b1.draw_commands();
	glPopMatrix();

	glPushMatrix();
	glTranslatef(0, 0, 0);
	b2.draw_commands();
	glPopMatrix();

	glPushMatrix();
	glTranslatef(150, 0, 0);
	b3.draw_commands();
	glPopMatrix();


	glFlush();
	SDL_GL_SwapBuffers();
}

void
handle_events()
{
	SDL_Event e;
	/* Process as many events as are pending. */
	while(SDL_PollEvent(&e)) {
		switch(e.type) {
		case SDL_KEYDOWN:

			switch(e.key.keysym.sym) {
			case SDLK_ESCAPE:
				done = true;
				break;

			case SDLK_UP:
				break;

			case SDLK_DOWN:
				break;

			case SDLK_RETURN:
				if(e.key.keysym.mod & KMOD_CTRL)
					SDL_WM_ToggleFullScreen(screen);
				break;

			case SDLK_s:
				if(smooth) {
					std::cout << "Flat shading\n";
					glShadeModel(GL_FLAT);
					smooth = false;
				} else {
					std::cout << "Smooth shading\n";
					glShadeModel(GL_SMOOTH);
					smooth = true;
				}
				break;

			case SDLK_l:
			{
				GLfloat tmp[4] = {-10000, 10000,
						  10000, 10000};
				glGetLightfv(GL_LIGHT0, GL_POSITION, tmp);
				std::cout << "pos: (" << tmp[0] << ", "
					  << tmp[1] << ", " << tmp[2]
					  << ")\n";
				break;
			}

			default:
				break;

			} // switch(e.key.keysym.sym)

			break;

		case SDL_VIDEORESIZE:
			std::cout << e.resize.w << " " << e.resize.h << "\n";
			resize(e.resize.w, e.resize.h);
			break;

		case SDL_QUIT:
			done = true;

		default:
			break;

		} // switch(e.type)

	} // while(SDL_PollEvent(&e))

} // handle_events()


class AtExit
{
public:
	bool init;

	AtExit()
	 : init(false)
	{
	}

	~AtExit()
	{
		if(init)
			SDL_Quit();
	}
};

#define print_SDL_GL_attr_val(attr) {int glattr; if(SDL_GL_GetAttribute(attr, &glattr) == 0) {std::cout << "SDL GL attr val " << #attr << " = " << glattr << "\n";} else {std::cout << "Error getting GL attr val for " << int(attr) << "\n";} }
int
main()
{
	std::srand(std::time(NULL));

	if(SDL_Init(SDL_INIT_NOPARACHUTE|SDL_INIT_VIDEO) == -1)
		throw std::runtime_error("SDL not initialised!");

	AtExit at_exit;
	at_exit.init = true;

	SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

	screen = SDL_SetVideoMode(scr_w, scr_h, 0,
				  SDL_HWSURFACE|SDL_OPENGL
				  |SDL_RESIZABLE);

	if(!screen)
		throw std::runtime_error("OpenGL not initialised!");

	SDL_EnableKeyRepeat(250, 30);

	print_SDL_GL_attr_val(SDL_GL_RED_SIZE);
	print_SDL_GL_attr_val(SDL_GL_GREEN_SIZE);
	print_SDL_GL_attr_val(SDL_GL_BLUE_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ALPHA_SIZE);
	print_SDL_GL_attr_val(SDL_GL_DOUBLEBUFFER);
	print_SDL_GL_attr_val(SDL_GL_BUFFER_SIZE);
	print_SDL_GL_attr_val(SDL_GL_DEPTH_SIZE);
	print_SDL_GL_attr_val(SDL_GL_STENCIL_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_RED_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_GREEN_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_BLUE_SIZE);
	print_SDL_GL_attr_val(SDL_GL_ACCUM_ALPHA_SIZE);

	if(smooth)
		glShadeModel(GL_SMOOTH);
	else
		glShadeModel(GL_FLAT);
	
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	const GLfloat ambient0[] = {0.5, 0.5, 0.5, 1};
	const GLfloat diffuse0[] = {0.9, 0.9, 0.9, 1};
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient0);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse0);

	glEnable(GL_DEPTH_TEST);
	glClearColor(0.4, 0.125, 0.125, 1.0);

	resize(scr_w, scr_h);
	draw();

	while(!done) {
		handle_events();
		draw();
	}

	return 0;
}

