/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file util.cc @see util.hh */

#include "util.hh"

namespace XBobble
{

std::set<std::string> Singleton_Class::class_names;

Singleton_Class::Singleton_Class(const std::string& arg)
 : my_name(arg)
{
	// exists!
	if(class_names.find(arg) != class_names.end())
		throw Singleton_Object_Error(arg);

	// doesn't exist!
	class_names.insert(arg);
}

Singleton_Class::~Singleton_Class()
{
	class_names.erase(my_name);
}

bool
Singleton_Class::exists(const std::string& arg)
{
	return class_names.find(arg) != class_names.end();
}

} // namespace XBobble

