#!/bin/sh

if test -n "$PAGER"; then
    pager=$PAGER
else
    pager_less=`which less`
    pager_more=`which more`
    if test -x "$pager_less"; then
	pager=$pager_less
    elif test -x "$pager_more"; then
	pager=$pager_more
    fi
fi

pager_param=""
if echo $pager | grep less > /dev/null; then
    if `$pager --help | grep "\-R" > /dev/null`; then
	pager_param="-R"
    elif `$pager --help | grep "\-r" > /dev/null`; then 
	pager_param="-r"
    else
	pager_param=""
    fi
fi

xdclient "$@" | $pager $pager_param

