/* Simprun/Expr.C
 *
 * Expression classes implementation
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */
 
#include "Expr.h"
#include <iostream>
#include <fstream>
#include "config.h"
using namespace std;
/*
float  a_div::eval(vector<string>& data_arr, fstream& eval_out){ }
float  a_minus::eval(vector<string>& data_arr, fstream& eval_out){ }
float  a_plus::eval(vector<string>& data_arr, fstream& eval_out){ }
float  greater_eq::eval(vector<string>& data_arr, fstream& eval_out){ }
float  greater_than::eval(vector<string>& data_arr, fstream& eval_out){ }
float  is_eq::eval(vector<string>& data_arr, fstream& eval_out){ }
float  is_noeq::eval(vector<string>& data_arr, fstream& eval_out){ }
float  land::eval(vector<string>& data_arr, fstream& eval_out){ }
float  less_eq::eval(vector<string>& data_arr, fstream& eval_out){ }
float  less_than::eval(vector<string>& data_arr, fstream& eval_out){ }
float  lor::eval(vector<string>& data_arr, fstream& eval_out){ }
float  mr_expr::eval(vector<string>& data_arr, fstream& eval_out){ }
float  mult::eval(vector<string>& data_arr, fstream& eval_out){ }
float  name_expr::eval(vector<string>& data_arr, fstream& eval_out){ }
float  number::eval(vector<string>& data_arr, fstream& eval_out){ } 
float  paren_expr::eval(vector<string>& data_arr, fstream& eval_out){ }
float  uni_minus::eval(vector<string>& data_arr, fstream& eval_out){ }
*/

/*==========================================================*/
/*
float expr_node::eval(vector<string>& data_arr, fstream& eval_out){
	cerr << "cannot be here\n"; exit(-1);
}
*/
float uni_minus::eval(vector<string>& data_arr, fstream& eval_out) { return -(operand->eval(data_arr, eval_out)); }

float paren_expr::eval(vector<string>& data_arr, fstream& eval_out) { 
	return operand->eval(data_arr, eval_out); }

float a_plus::eval(vector<string>& data_arr, fstream& eval_out){ 
	return (left_e->eval(data_arr, eval_out)+right_e->eval(data_arr, eval_out));}

float mult::eval(vector<string>& data_arr, fstream& eval_out){ 
	return left_e->eval(data_arr, eval_out)*right_e->eval(data_arr, eval_out);}

float a_minus::eval(vector<string>& data_arr, fstream& eval_out) { 
	return left_e->eval(data_arr, eval_out) - right_e->eval(data_arr, eval_out) ;
}

float a_div::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)/right_e->eval(data_arr, eval_out);}

float less_eq::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)<=right_e->eval(data_arr, eval_out);}

float less_than::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)<right_e->eval(data_arr, eval_out);}

float greater_eq::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)>=right_e->eval(data_arr, eval_out);}

float greater_than::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)>right_e->eval(data_arr, eval_out);}

float is_eq::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)==right_e->eval(data_arr, eval_out);}

float is_noeq::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)!=right_e->eval(data_arr, eval_out);}

float number::eval(vector<string>& data_arr, fstream& eval_out) { return value; }

float lor::eval(vector<string>& data_arr, fstream& eval_out){ return (left_e->eval(data_arr, eval_out)||right_e->eval(data_arr, eval_out));}

float land::eval(vector<string>& data_arr, fstream& eval_out){ return left_e->eval(data_arr, eval_out)&&right_e->eval(data_arr, eval_out);}

float mr_expr::eval(vector<string>& data_arr, fstream& eval_out){
	int tmp_mask = mask & 0xFF;
	return data_arr[column_no/100][column_no%100]&tmp_mask;
}

float name_expr::eval(vector<string>&data_arr, fstream& eval_out){
	return s_ent->get_value();
}


/*===========================================================*/


void  a_div::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "/"; right_e->print(edit_out); }
void  a_minus::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "-"; right_e->print(edit_out); }
void  a_plus::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "+"; right_e->print(edit_out); }
void  greater_eq::print(fstream& edit_out){ left_e->print(edit_out); edit_out << ">="; right_e->print(edit_out); }
void  greater_than::print(fstream& edit_out){ left_e->print(edit_out); edit_out << ">"; right_e->print(edit_out); }
void  is_eq::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "=="; right_e->print(edit_out); }
void  is_noeq::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "!="; right_e->print(edit_out); }
void  land::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "&&"; right_e->print(edit_out); }
void  less_eq::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "<="; right_e->print(edit_out); }
void  less_than::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "<"; right_e->print(edit_out); }
void  lor::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "||"; right_e->print(edit_out); }
void  mr_expr::print(fstream& edit_out){ 
	// the 0xff is because if its single punch I set 1<<31 in mask in the
	// lexer lex.l
	int tmp = mask & 0xff;
	edit_out << "c" << column_no << "'"<< tmp << "'";
	}
void  mult::print(fstream& edit_out){ left_e->print(edit_out); edit_out << "*"; right_e->print(edit_out); }
void  name_expr::print(fstream& edit_out){ s_ent->print_name(edit_out); }
void  number::print(fstream& edit_out){ edit_out << value; }
void  paren_expr::print(fstream& edit_out){ edit_out << "(" ; operand->print(edit_out); edit_out << ")"; }
void  uni_minus::print(fstream& edit_out){ edit_out << "-"; operand->print(edit_out); }
