/* Simprun/Stmt.h
 *
 * Edit section statement classes 
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

#ifndef __Stmt_h
#define __Stmt_h

#include <iostream>
#include <fstream>
#include "Expr.h"
#include "sym_tab.h"

using namespace std;


class stmt_node;
class expr_stmt;
class if_stmt;
class assgn_stmt;
class int_decl;
class cmpd_stmt;
class float_decl;


#include "scope.h"
extern vector<scope*> active_scope_list;

class stmt_node{
	public:
	// later on I don't think type will be needed
	int type;
	int error;
	int line_number;
	virtual void print(fstream& edit_out)=0;
	virtual void eval(vector <string>& data_arr, fstream& eval_out){
		eval_out << "stmt_node::eval() should not be called \n";
	}
	struct stmt_node * next_stmt, * prev_stmt;
	stmt_node(): next_stmt(NULL), prev_stmt(NULL){
	}
	virtual ~stmt_node(){
		cout << "stmt_node destructor called" << endl;
		stmt_node* st_ptr = this;
		while(st_ptr->next_stmt) {
			st_ptr=st_ptr->next_stmt;
			//edit_out << "inside while here\n";
			cout << "following chain" << endl;
		}
		cout << "reached here\n";
		while(st_ptr){
			delete st_ptr->next_stmt;
			cout << "deleting" << endl;
			st_ptr=st_ptr->prev_stmt;
		}
	}
};

void print_stmt_lst(stmt_node *& st, fstream& edit_out);
void eval_stmt_lst(stmt_node*  st, vector<string>& data_arr, fstream& eval_out);
class expr_stmt: public stmt_node{
	public:
	struct expr_node * expr;
	expr_stmt(struct expr_node * e): stmt_node(){
		expr=e;
	}
	void print(fstream& edit_out){	
		if (expr) { 
			//edit_out << "Hello,World\n";
			expr->print(edit_out); 
			edit_out << ";\n";
		} 
	}
	void eval(vector <string>& data_arr, fstream& eval_out){
		eval_out << "expr_stmt::eval()\n";
			
		expr->eval(data_arr, eval_out);
	}
};

class if_stmt: public stmt_node{
	public:
	struct expr_node * condition;
	struct stmt_node * if_body;
	struct stmt_node * else_body;
	if_stmt(expr_node * c, stmt_node * i_body, stmt_node * el_body):
		stmt_node(),
		condition(c), if_body(i_body), else_body(el_body){
	}
	// may not be required
	~if_stmt(){
		delete condition;
		delete if_body;
		delete else_body;
		//cout << "if_stmt destructor called" << endl;
	}

	void print(fstream& edit_out){
		edit_out << "if(";
		condition->print(edit_out); edit_out << ")";
		edit_out << endl;
		print_stmt_lst(if_body, edit_out);
		
		edit_out << endl;
		if( else_body) {
			edit_out << "else " ;
			print_stmt_lst(else_body, edit_out);
		}
	}	

	void eval(vector<string>& data_arr, fstream& eval_out){
		//condition->eval(eval_out); 
		//condition->eval(data_arr, eval_out); 
		//eval_out << endl;
		if( condition->eval(data_arr, eval_out) ) {
			eval_stmt_lst(if_body, data_arr, eval_out);
		} else if( else_body) {
			eval_stmt_lst(else_body, data_arr, eval_out);
		}
		eval_out << "eval:if_stmt\n";
	}

};

class assgn_stmt: public stmt_node{
	public:
	struct symtab_ent * symp;	
	struct expr_node * expr;
	assgn_stmt(symtab_ent * s_ent, expr_node * e): stmt_node(),
		symp(s_ent), expr(e) { }
	void  print(fstream& edit_out){
		edit_out << symp->name << '=' ;
		expr->print(edit_out);
		edit_out << ";\n";
		//<< symp->get_value() << endl;
	}

	void  eval(vector<string>& data_arr, fstream& eval_out){
		//eval_out << symp->name << '=' ;
		//expr->print(eval_out);
		//eval_out << ";\n";
		//<< symp->get_value() << endl;
		symp->set_value(expr->eval(data_arr, eval_out));
		eval_out << "eval::assgn_stmt\n";
	}

};

class int_decl: public stmt_node{
	public:
	struct symtab_ent * symp;
	int_decl(symtab_ent * s_ent): symp(s_ent), stmt_node() {}
	void print(fstream& edit_out){
		edit_out << "int " << symp->name << ";" << endl;
	}
	void eval(vector<string>& data_arr, fstream& eval_out){
		//eval_out << "int decl\n";
	}
};

class cmpd_stmt: public stmt_node{
	public:
	stmt_node * c_stmt;
	struct scope* sc;
	cmpd_stmt(): c_stmt(NULL), stmt_node() {
		sc = new scope();
	}
	cmpd_stmt(stmt_node * c_s): c_stmt(c_s), stmt_node() {
		sc = new scope();
	}
	void print(fstream& edit_out){
		edit_out << "{" ;
		//c_stmt->print(edit_out);
		//cout << "/*printing compound statement*/\n";
		print_stmt_lst(c_stmt, edit_out);
		edit_out << "}";
	}
	void eval(vector<string>& data_arr, fstream& eval_out){
		//eval_out << "{" ;
		//c_stmt->print(eval_out);
		//eval_out << "}";
		eval_out << "eval: cmpd_stmt\n";
		active_scope_list.push_back(sc);
		eval_stmt_lst(c_stmt, data_arr, eval_out);
		active_scope_list.pop_back();
	}

};

class float_decl: public stmt_node{
	public:
	struct symtab_ent * symp;
	float_decl(symtab_ent * s_ent): symp(s_ent), stmt_node() {}
	void print(fstream& edit_out){
		edit_out << "float " << symp->name << ";" << endl;
	}
	void eval(vector<string>& data_arr, fstream& eval_out){
		//eval_out << "float decl\n";
	}
};
#include "generate_program.h"
class count_stmt: public stmt_node{
	public:
	struct hole_count_container* h_cont;
	string text;
	public:
	count_stmt(int sc, int ec, string text){
		h_cont = new hole_count_container(sc, ec);
		if(!h_cont){
			cerr << 
			"Failed to allocate memory for hole_count_container" <<
				endl;
			exit(1);
		}
	}
	void print(fstream& edit_out){
		edit_out << "count c(" <<
			h_cont->start_col << "," <<
			h_cont->end_col << ")"  
			<< "$" << text  << "$" << ";" << endl;
	}
	void eval(vector <string>& data_arr, fstream& eval_out);
};

class	for_stmt: public stmt_node {
	public:
	expr_node * initializer;
	expr_node * test_condn;
	expr_node * incr;
	stmt_node * for_body;
	for_stmt(expr_node *i, expr_node * t, expr_node *inc, stmt_node *b): 
		initializer(i), test_condn(t), incr(inc), for_body(b)
		{}
	void print(fstream& edit_out){
		edit_out << "for (" ;
			initializer->print(edit_out); edit_out << ";";
			test_condn->print(edit_out); edit_out << ";";
			incr->print(edit_out); edit_out <<   ")" ;
			for_body->print(edit_out);
	}
	void eval(vector <string>& data_arr, fstream& eval_out){
		// not yet implemented 
		for( initializer->eval(data_arr, eval_out);
			test_condn->eval(data_arr, eval_out);
			incr->eval(data_arr, eval_out) ){
			eval_stmt_lst(for_body, data_arr, eval_out);
		}
	}
};

class	emit_stmt: public stmt_node {
	int column_no;
	int mask;
	public:
	emit_stmt(int c_no, int codes) { column_no=c_no; mask=codes; }
	void eval(vector <string>& data_arr, fstream& eval_out) {
		char tmp_mask = mask & 0xFF;
		char c=data_arr[column_no/100][column_no%100];
		c=c|mask;
		data_arr[column_no/100][column_no%100]=c;
	}
	void print(fstream& edit_out){
		edit_out << "emit " ;
		int tmp = mask & 0xff;
		edit_out << "c" << column_no << "'"<< tmp << "';\n";
	}
};

class	delete_stmt: public stmt_node {
	int column_no;
	int mask;
	public:
	delete_stmt(int c_no, int codes) { column_no=c_no; mask=codes; }
	void eval(vector <string>& data_arr, fstream& eval_out) {
		char tmp_mask = ~mask;
		char c=data_arr[column_no/100][column_no%100];
		c=c&tmp_mask;
		data_arr[column_no/100][column_no%100]=c;
	}
	void print(fstream& edit_out){
		edit_out << "delete " ;
		int tmp = mask & 0xff;
		edit_out << "c" << column_no << "'"<< tmp << "';\n";
	}
};

//#include <list>
//void print_stmt_lst(list<stmt_node*>& stmt_node_list);
#endif /* __Stmt_h */
