/* XtCC/sym_tab.C
 *
 * The symbol table classes implementation. Actually now the symbol table
 * is part of each compound body statement 
 *
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */

#ifndef _SYMTAB_H
#define _SYMTAB_H
#include <string>
#include <fstream>
#include <iostream>
using namespace std;

struct symtab_ent{
public:
	string name;
	float virtual get_value(){
		cout << "symtab_ent::get_value() should never be called\n";
	};
	void print_name(fstream& edit_out){
		edit_out << name ;
	}
	virtual void set_value(float v){ cout<<"should never be called\n"; }
};

struct symtab_ent_int : public symtab_ent {
public:
	int value;
	float get_value() { return value; }
	void set_value(float v){ value=v; }
};


struct symtab_ent_float : public symtab_ent {
public:
	float value;
	float get_value() { return value; }
	void set_value(float v) { value = v; }
};

#endif /* _SYMTAB_H */
