/*
 * yauap - A simple commandline frontend for GStreamer
 * Copyright (c) 2006 Sascha Sommer <ssommer@suse.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 */


#ifndef YAUAP_H
#define YAUAP_H 1


/* the player struct */
typedef struct player_s{
    void* yauap_priv;
    int verbose;
    /* methods */
    int (*quit)(struct player_s* player);
    int (*pause)(struct player_s* player);
    int (*can_decode)(const char* url);
    int (*load)(struct player_s* player,const char* url);
    int (*stop)(struct player_s* player);
    int (*start)(struct player_s* player);
    unsigned int (*get_time_length)(struct player_s* player);
    unsigned int (*get_time_position)(struct player_s* player);
    int (*seek)(struct player_s* player,unsigned int offset);
    float (*get_volume)(struct player_s* player);
    int (*set_volume)(struct player_s* player,float volume);
    int (*get_metadata)(struct player_s* player,char ***metadata);
    /* get audio cd contents: overwrites the set cdrom_device when device is NULL */
    int (*get_audio_cd_contents)(struct player_s* player,char* device,char*** tracks);
#define SCOPE_SIZE 2048
    /* get current scope buffer - data has to be at least SCOPE_SIZE bytes */
    int (*get_scopedata)(struct player_s* player,char * data);
} player_t;


typedef struct yauap_frontend_s {
    void (*free)(struct yauap_frontend_s* frontend);
#define SIGNAL_METADATA 1
#define SIGNAL_EOS      2
#define SIGNAL_ERROR    3
    void (*signal_cb)(struct yauap_frontend_s* frontend,unsigned int signal,char* message);
    void* priv;
    struct player_s* player;
} yauap_frontend_t;






#endif

