/*  Zutils - Utilities dealing with compressed files
    Copyright (C) 2009, 2010 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

const char * const Program_name = "Zutils";
const char * const program_name = "zutils";
const char * const program_year = "2010";
extern const char * invocation_name;
extern const char * util_name;

extern int verbosity;

const char * const simple_extensions[] = { ".gz", ".lz", ".bz2", ".xz", 0 };

enum { bzip2_magic_size = 3 };
enum {  gzip_magic_size = 2 };
enum {  lzip_magic_size = 4 };
enum {    xz_magic_size = 5 };
const uint8_t bzip2_magic[bzip2_magic_size] = { 'B', 'Z', 'h' };
const uint8_t  gzip_magic[ gzip_magic_size] = { '\x1F', '\x8B' };
const uint8_t  lzip_magic[ lzip_magic_size] = { 'L', 'Z', 'I', 'P' };
const uint8_t    xz_magic[   xz_magic_size] = { '\xFD', '7', 'z', 'X', 'Z' };


int readblock( const int fd, uint8_t * const buf, const int size ) throw();
int writeblock( const int fd, const uint8_t * const buf, const int size ) throw();
bool feed_data( const int infd, const int outfd,
                const uint8_t * magic_data, const int magic_size );
bool set_data_feeder( int * const infdp, pid_t * const pidp );

void show_help_addr() throw();
void show_version( const char * const Util_name = 0 ) throw();
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false ) throw();
void internal_error( const char * const msg );

bool test_format( const int infd, std::string & file_type,
                  const uint8_t ** magic_data, int * magic_sizep );

int wait_for_child( const pid_t pid, const char * const name );
