/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.digikam.org
 *
 * Date        : 2005-17-06
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008-2015 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2009      by Luka Renko <lure at kubuntu dot org>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// To disable warnings under MSVC2008 about POSIX methods().
#ifdef _MSC_VER
#pragma warning(disable : 4996)
#endif

#include "plugin_flickr.h"

// C ANSI includes

extern "C"
{
#include <unistd.h>
}

//Qt includes

#include <QApplication>
#include <QStandardPaths>
#include <QDir>

// KDE includes

#include <kpluginfactory.h>
#include <kwindowsystem.h>

// LibKIPI includes

#include <KIPI/Interface>

// Local includes

#include "flickrwindow.h"
#include "selectuserdlg.h"
#include "kipiplugins_debug.h"

namespace KIPIFlickrPlugin
{

K_PLUGIN_FACTORY(FlickrExportFactory, registerPlugin<Plugin_Flickr>();)

Plugin_Flickr::Plugin_Flickr(QObject* const parent, const QVariantList& /*args*/)
    : Plugin(parent, "Flickr")
{
    qCDebug(KIPIPLUGINS_LOG) << "Plugin_Flickr plugin loaded";

    setUiBaseName("kipiplugin_flickrui.rc");
    setupXML();
    
    m_actionFlickr = 0;
    m_action23     = 0;
    m_actionZooomr = 0;

    m_dlgFlickr    = 0;
    m_dlg23        = 0;      
    m_dlgZooomr    = 0;
    
    selectFlickr   = 0;
    select23       = 0;
    selectZoomr    = 0;    
}

Plugin_Flickr::~Plugin_Flickr()
{
}

void Plugin_Flickr::setup(QWidget* const widget)
{
    m_dlgFlickr = 0;
    m_dlg23     = 0;
    m_dlgZooomr = 0;

    Plugin::setup(widget);

    if (!interface())
    {
        qCCritical(KIPIPLUGINS_LOG) << "Kipi interface is null!";
        return;
    }

    setupActions();
}

void Plugin_Flickr::setupActions()
{
    setDefaultCategory(ExportPlugin);

    m_actionFlickr = new QAction(this);
    m_actionFlickr->setText(i18n("Export to Flick&r..."));
    m_actionFlickr->setIcon(QIcon::fromTheme(QStringLiteral("kipi-flickr")));
    m_actionFlickr->setShortcut(QKeySequence(Qt::ALT + Qt::SHIFT + Qt::Key_R));
    
    selectFlickr = new SelectUserDlg(0,QStringLiteral("Flickr"));
    
    connect(m_actionFlickr, SIGNAL(triggered(bool)),
            this, SLOT(slotActivateFlickr()));

    addAction(QStringLiteral("flickrexport"), m_actionFlickr);

    m_action23 = new QAction(this);
    m_action23->setText(i18n("Export to &23..."));
    m_action23->setIcon(QIcon::fromTheme(QStringLiteral("kipi-hq")));
    m_action23->setShortcut(QKeySequence(Qt::ALT + Qt::SHIFT + Qt::Key_2));

    select23 = new SelectUserDlg(0,QStringLiteral("23"));
    
    connect(m_action23, SIGNAL(triggered(bool)),
            this, SLOT(slotActivate23()));

    addAction(QStringLiteral("23export"), m_action23);

    m_actionZooomr = new QAction(this);
    m_actionZooomr->setText(i18n("Export to &Zooomr..."));
    m_actionZooomr->setIcon(QIcon::fromTheme(QStringLiteral("kipi-zooomr")));
    m_actionZooomr->setShortcut(QKeySequence(Qt::ALT + Qt::SHIFT + Qt::Key_Z));

    selectZoomr = new SelectUserDlg(0,QStringLiteral("Zooomr"));
    
    connect(m_actionZooomr, SIGNAL(triggered(bool)),
            this, SLOT(slotActivateZooomr()));

    addAction(QStringLiteral("Zooomrexport"), m_actionZooomr);
}

void Plugin_Flickr::slotActivateFlickr()
{
    selectFlickr->reactivate();
    QString tmp = QStandardPaths::writableLocation(QStandardPaths::TempLocation)+ QLatin1String("/")+ QLatin1String("kipi-flickrexportplugin-") + QString::number(getpid()) + QLatin1String("/");
    QDir().mkpath(tmp);
    
    if (!m_dlgFlickr)
    {
        // We clean it up in the close button
        m_dlgFlickr = new FlickrWindow(tmp, QApplication::activeWindow(), QStringLiteral("Flickr"), selectFlickr);
    }
    else
    {
        if (m_dlgFlickr->isMinimized())
        {
            KWindowSystem::unminimizeWindow(m_dlgFlickr->winId());
        }

        KWindowSystem::activateWindow(m_dlgFlickr->winId());
    }

    m_dlgFlickr->reactivate();
}

void Plugin_Flickr::slotActivate23()
{
    select23->reactivate();
    QString tmp = QStandardPaths::writableLocation(QStandardPaths::TempLocation)+ QLatin1String("/")+ QLatin1String("kipi-23exportplugin-") + QString::number(getpid()) + QLatin1String("/");
    QDir().mkpath(tmp);
    
    if (!m_dlg23)
    {
        // We clean it up in the close button
        m_dlg23 = new FlickrWindow(tmp, QApplication::activeWindow(), QStringLiteral("23"), select23);
    }
    else
    {
        if (m_dlg23->isMinimized())
        {
            KWindowSystem::unminimizeWindow(m_dlg23->winId());
        }

        KWindowSystem::activateWindow(m_dlg23->winId());
    }

    m_dlg23->reactivate();
}

void Plugin_Flickr::slotActivateZooomr()
{
    selectZoomr->reactivate();
    QString tmp = QStandardPaths::writableLocation(QStandardPaths::TempLocation)+ QLatin1String("/")+ QLatin1String("kipi-Zooomrexportplugin-") + QString::number(getpid()) + QLatin1String("/");
    QDir().mkpath(tmp);
    
    if (!m_dlgZooomr)
    {
        // We clean it up in the close button
        m_dlgZooomr = new FlickrWindow(tmp, QApplication::activeWindow(), QStringLiteral("Zooomr"), selectZoomr);
    }
    else
    {
        if (m_dlgZooomr->isMinimized())
        {
            KWindowSystem::unminimizeWindow(m_dlgZooomr->winId());
        }

        KWindowSystem::activateWindow(m_dlgZooomr->winId());
    }

    m_dlgZooomr->reactivate();
}

} // namespace KIPIFlickrPlugin

#include "plugin_flickr.moc"
