/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBOARDWIDGET_H
#define SKGBOARDWIDGET_H
/** @file
* This file is a generic for board widget.
* @see SKGReport
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "skgwidget.h"
#include "skgbasegui_export.h"

class QAction;
class QMenu;
class QToolButton;
class QFrame;
class QGridLayout;
class QLabel;
class QAction;
class QMenu;
class SKGZoomSelector;

/**
 * This file is a generic for board widget
 */
class SKGBASEGUI_EXPORT SKGBoardWidget : public SKGWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param iDocument the document
     * @param iTitle the title
     * @param iZoomable for a zoomable widget
     */
    explicit SKGBoardWidget(SKGDocument* iDocument, const QString& iTitle, bool iZoomable = false);

    /**
     * Default Destructor
     */
    virtual ~SKGBoardWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState() override;

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState) override;

    /**
     * Get the widget for drag and drop
     * MUST BE OVERWRITTEN
     * @return the widget.
     */
    virtual QWidget* getDragWidget();

    /**
     * Set the main widget
     * @param iWidget the main widget
     */
    virtual void setMainWidget(QWidget* iWidget);

    /**
     * Set the main title
     * @param iTitle the main title
     */
    virtual void setMainTitle(const QString& iTitle);

    /**
     * Get the main title
     * @return the main title
     */
    virtual QString getMainTitle();

    /**
     * Get the original title
     * @return the original title
     */
    virtual QString getOriginalTitle();

    /**
     * Set the zoom ratio
     * @param iRation the zoom ratio (1 <= iRation <=5)
     */
    virtual void setZoomRation(double iRation);

    /**
     * Get the zoom ratio
     * @return the zoom ratio
     */
    virtual double getZoomRation();

    /**
     * Add an action
     * @param iAction the action to add
     */
    virtual void addAction(QAction* iAction);

    /**
     * Insert an action
     * @param iPos the position of the insertion
     * @param iAction the action to add
     */
    virtual void insertAction(int iPos, QAction* iAction);

    /**
     * Hide title and configuration widget
     */
    virtual void hideTitle();

Q_SIGNALS:

    /**
     * Sent when the remove is requested
     */
    void requestRemove();

    /**
    * Sent when the move is requested
    * @param iMove the move to apply
    */
    void requestMove(int iMove);

private Q_SLOTS:
    void onZoom(int iZoom);
    void requestMoveBefore();
    void requestMoveAfter();
    void requestMoveFirst();
    void requestMoveLast();
    void onRenameTitle();

private:
    Q_DISABLE_COPY(SKGBoardWidget)

    QLabel* m_Title;
    QGridLayout* m_gridLayout;
    QFrame* m_frame;
    QToolButton* m_toolButton;
    QMenu* m_menu;
    SKGZoomSelector* m_zoomMenu;
    double m_zoomRatio;
    QSize m_initialSize;
    QFrame* m_line;
    QAction* m_menuRename;
    QString m_title;
    QString m_titleDefault;
};

#endif  // SKGBOARDWIDGET_H
