/*
 *
 * Copyright (C) 2002 Zsolt Rizsanyi <rizsanyi@myrealbox.com>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef __DPMS_CONTROL_H__
#define __DPMS_CONTROL_H__

/**
 * DPMS Control class
 *
 * You can call the static methods of this class directly
 * from within another class to control the DPMS or
 * to get its current status.
 *
 */
class DpmsControl
{
public:
    /**
     * Static accessor method to get the status of the dpms.
     * Returns true if DPMS is currently enabled,
     * false if it is disabled.
     */
    static bool getDpmsStatus();

    /**
     * Static accessor method to enable or disable DPMS. Returns
     * true if the operation was successful, false if it was not.
     */
    static bool enableDpms(bool enable = true);

    /**
     * Disables DPMS. Calls enableDpms(false).
     */
    static bool disableDpms();

private:
    bool        dpmsWasEnabled;
};

#endif
