/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "audiomanager.h"

#include "kdetvmixerplugin.h"
#include "pluginfactory.h"
#include <kdebug.h>


AudioManager::AudioManager(PluginFactory *pf)
{
	_mixer = 0;
	_pf = pf;
	scanPlugins();
}

void AudioManager::rescanPlugins()
{
	scanPlugins();
}


void AudioManager::scanPlugins()
{
	QPtrList<PluginDesc>& mixerPlugins(_pf->mixerPlugins());
	PluginDesc *plug = mixerPlugins.first();
	
	bool hasMixer = false;
	for (; plug; plug = mixerPlugins.next()) {
		kdDebug() << "Found Mixer plugin:" << endl;
		kdDebug() << plug->name << endl;
		kdDebug() << plug->author << endl;
		kdDebug() << plug->comment << endl;
		if (plug->enabled) {
			if (_mixer) {
				if (_mixer->pluginDescription() == plug) {
					hasMixer = true;
					break;
				} else {
					_mixer->destroy();
					_mixer = 0;
				}
			}
			KdetvMixerPlugin *f = _pf->getMixerPlugin(plug);

			if (f) {
				connect(f, SIGNAL(volumeChanged(int, int)),
                        this, SIGNAL(volumeChanged(int, int)));
				_mixer = f;
				hasMixer = true;
				break;
			}
		}
		else
		    kdDebug() << "This plugin is disabled" << endl;
	}

	// if no enabled mixer found then delete old
	if (!hasMixer && _mixer) {
        _mixer->destroy();
		_mixer = 0;
	}

	emit mixerAvailable(hasMixer);
}


AudioManager::~AudioManager()
{
    if (_mixer) _mixer->destroy();
}


int AudioManager::setVolume(int left, int right)
{
	if (!_mixer)
		return -1;

	return _mixer->setVolume(left, right);
}


int AudioManager::setVolume(int vol)
{
	return setVolume(vol, vol);
}


int AudioManager::volumeLeft()
{
	if (!_mixer)
		return -1;

	return _mixer->volumeLeft();
}


int AudioManager::volumeRight()
{
	if (!_mixer)
		return -1;

	return _mixer->volumeRight();
}


int AudioManager::setMuted(bool mute)
{
	if (!_mixer)
		return -1;

	return _mixer->setMuted(mute);
}


bool AudioManager::muted()
{
	if (!_mixer)
		return false;

	return _mixer->muted();
}

KdetvMixerPlugin *AudioManager::plugin()
{
    return _mixer;
}


#include "audiomanager.moc"

// vim: ts=4 sw=4
