// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __KDETVPLUGINBASE_H
#define __KDETVPLUGINBASE_H

#include <qobject.h>
#include <qstring.h>
#include "pluginfactory.h"

class KConfig;
class Kdetv;
class KActionCollection;
class KXMLGUIFactory;

/**
 * Plugin base class
 */
class KdetvPluginBase : public QObject
{
    Q_OBJECT

friend class PluginFactory;

public:
    KdetvPluginBase(Kdetv *ktv, const QString& cfgkey, QObject *parent = 0, const char* name = 0);
    virtual ~KdetvPluginBase();

    PluginDesc* const pluginDescription() const;

    /**
     * Plugins can override this if they want to install GUI elements to the kdetv client.
     * This method will be called when all the gui is properly initialized.
     */
    virtual void installGUIElements(KXMLGUIFactory * /*guiFactory*/,
                                    KActionCollection * /*actionCollection*/) { }

    /**
     * If you install GUI elements, also provide a method to remove them on plugin unload!
     */
    virtual void removeGUIElements(KXMLGUIFactory * /*guiFactory*/,
                                   KActionCollection * /*actionCollection*/) { }

    Kdetv *driver() const;

    /**
     * Call if you don't use the plugin any more. Don't just delete!
     */
    void destroy() { _description->getFactory()->putPlugin(_description); };

public slots:
    virtual QWidget* configWidget(QWidget *parent, const char *name);
    virtual void saveConfig();
    
protected:
    PluginDesc* _description;
    KConfig *_cfg;

private:
    Kdetv *_ktv;
};

#endif
