// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CHANNELIOZAPPING_H
#define CHANNELIOZAPPING_H

#include <qdom.h>

#include "channelio.h"

/**
 * Implements the Zapping (http://zapping.sf.net) XML channel format.
 * This is a read only channel format.
 *
 * @version $Id: channeliozapping.h,v 1.3 2004/03/23 22:00:23 dziegel Exp $
 * @author Zsolt Rizsanyi, rizsanyi@myrealbox.com
 */
class ChannelIOFormatZapping : public KdetvChannelPlugin
{
public:
    ChannelIOFormatZapping(Kdetv *ktv, QObject *parent = 0L, const char *name = 0L);
    virtual ~ChannelIOFormatZapping() {}

    virtual bool load(ChannelStore *store, QIODevice *file, const QString& fmt);
    virtual KdetvChannelPlugin::ChannelFileMetaInfo getMetaInfo(QIODevice *file, const QString& fmt);

    bool handlesFile( const QString& filename, int rflags) const;

protected:
    bool readDocument(ChannelStore *store, const QDomDocument& doc);

    /**
     * Finds a subtree of @p node with name @p name.
     */
    static QDomNode FindSubtree(const QDomNode& node, const QString& name);
};

#endif // CHANNELIOZAPPING_H
