;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; only nsis 2
;SetCompressor bzip2
SetCompressor LZMA
SetOverwrite on
SetCompress auto
SetDatablockOptimize on
SetDateSave on
;AutoCloseWindow true
CRCCheck on

;; dettagli ;;
DetailsButtonText " Show details "
; ShowInstDetails show

CompletedText " Completed "
InstallButtonText " Install "
MiscButtonText " Back " " Cancel " " Close "
;SetFont "comic sans ms" 12
SpaceTexts "  Required space:  " "  Available space:  "
UninstallButtonText " Uninstall "
UninstallText "FreePOPs uninstall." "Uninstalling: "
XPStyle on

Caption "FreePOPs"
SubCaption 0 ": this is free software!"
SubCaption 2 ": Install directory"
SubCaption 3 ": Files install"
SubCaption 4 ": Installation complete"

UninstallCaption "FreePOPs uninstall"
UninstallSubCaption 0 ": Confirm uninstall"
UninstallSubCaption 1 ": Files uninstall"
UninstallSubCaption 2 ": Uninstallation complete"

VIAddVersionKey ProductName "FreePOPs"
VIAddVersionKey LegalCopyright "GNU/GPL"
VIAddVersionKey ProductVersion "0.2.9"
VIAddVersionKey FileDescription "FreePOPs installer for Windows"
VIAddVersionKey FileVersion "0.2.9"
VIProductVersion 0.2.9.0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; The name of the installer
Name "FreePOPs 0.2.9"

;head
;BrandingText /TRIMCENTER "Installer by nsis.sf.net"
BrandingText "Installer by nsis.sf.net"


; The file to write
OutFile "FreePOPs-0.2.9.exe"

;Icon
Icon "freepops-setup.ico"
UninstallIcon "freepops-remove.ico"
;WindowIcon on

;theme
BGGradient off
;InstallColors a0a0ff 0000ff
InstallColors C0C0C0 404040
;InstallColors /WINDOWS
InstProgressFlags smooth colored


; The default installation directory
InstallDir $PROGRAMFILES\FreePOPs
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\NSIS_FreePOPs "Install_Dir"

;License
LicenseText "This is free software, distributed under the GNU/GPL license" \
	"Continue"
LicenseBkColor /windows
LicenseData "COPYING.txt"
LicenseForceSelection radiobuttons \
	"I like free software and I accept this license." \
	"I only use proprietary software, I'll never install this rubbish."

; The text to prompt the user to enter a directory
DirText "Choose a directory to install FreePOPs:"
;DirShow show


; The stuff to install
Section "FreePOPs (required)"
  SetOutPath $SYSDIR
  File "lwel-manifest.dll"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  ; Put file there
  File "*.exe"
  File "*.dll"
  File "*.txt"
  File "*.vbs"
  File "*.ico"
  File "config.lua"
  File /r "LUA"
  File /r "C"
  File /r "LANG"
  CreateDirectory $INSTDIR\LUA_UNOFFICIAL
  CreateDirectory $INSTDIR\LUA_UPDATES
  CreateDirectory $INSTDIR\LUA_UPDATES\LXP
  CreateDirectory $INSTDIR\LUA_UPDATES\BROWSER
  CreateDirectory $INSTDIR\LUA_UPDATES\SOAP
  CreateDirectory $INSTDIR\LANG
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\NSIS_FreePOPs "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM \
  	"Software\Microsoft\Windows\CurrentVersion\Uninstall\FreePOPs" \
	"DisplayName" \
	"NSIS FreePOPs (remove only)"
  WriteRegStr HKLM \
  	"Software\Microsoft\Windows\CurrentVersion\Uninstall\FreePOPs" \
	"UninstallString" \
	'"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"
SectionEnd

; optional section
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\FreePOPs"
  CreateDirectory "$SMPROGRAMS\FreePOPs\Debug"
  CreateDirectory "$SMPROGRAMS\FreePOPs\Scripts"
  CreateDirectory "$SMPROGRAMS\FreePOPs\Service"
  
  
  SetOverwrite off
  CreateShortCut "$SMPROGRAMS\FreePOPs\FreePOPs.lnk" \
  	"$INSTDIR\freepopsd.exe" "" "$INSTDIR\freepopsd.exe" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\FreePOPs-updater.lnk" \
  	"$INSTDIR\freepopsd.exe" "-e updater.lua php interactive" \
	"$INSTDIR\freepops-updater.ico"
  CreateShortCut "$SMPROGRAMS\FreePOPs\Debug\FreePOPs -vv (verbose log).lnk" \
  	"$INSTDIR\freepopsd.exe" "-vv" "$INSTDIR\freepopsd.exe" 0

  SetOverwrite on

  ; service
  CreateShortCut "$SMPROGRAMS\FreePOPs\Service\Manual (english).lnk" \
  	"$INSTDIR\SERVICE.txt" "" "$INSTDIR\SERVICE.txt" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Service\Manuale (italiano).lnk" \
  	"$INSTDIR\SERVICE.txt" "" "$INSTDIR\SERVICE.txt" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Service\Uninstall service.lnk" \
  	"$INSTDIR\freepopsservice.exe" "uninstall" "$INSTDIR\uninstall.exe" 0
  CreateShortCut \
	"$SMPROGRAMS\FreePOPs\Service\Install service (default options).lnk" \
  	"$INSTDIR\freepopsservice.exe" "install" "$INSTDIR\freepopsd.exe" 0
  CreateShortCut \
  	"$SMPROGRAMS\FreePOPs\Service\Install service (-p 110 -b 0.0.0.0).lnk" \
  	"$INSTDIR\freepopsservice.exe" "install -p 110 -b 0.0.0.0" \
	"$INSTDIR\freepopsd.exe" 0
  CreateShortCut \
  	"$SMPROGRAMS\FreePOPs\Service\Install service (-p 110 -b 0.0.0.0).lnk" \
  	"$INSTDIR\freepopsservice.exe" "install -p 110 -b 0.0.0.0" \
	"$INSTDIR\freepopsd.exe" 0
  CreateShortCut \
  	"$SMPROGRAMS\FreePOPs\Service\Install service (-b 0.0.0.0).lnk" \
  	"$INSTDIR\freepopsservice.exe" "install -b 0.0.0.0" \
	"$INSTDIR\freepopsd.exe" 0

  ; mail & FP
  CreateShortCut "$SMPROGRAMS\FreePOPs\Scripts\FreePOPs & Mail.lnk" \
  	"$INSTDIR\freepopsd.vbs" "" "$INSTDIR\freepopsd.vbs" 0
  CreateShortCut \
  	"$SMPROGRAMS\FreePOPs\Scripts\FreePOPs & Mail - Manual (english).lnk" \
	"$INSTDIR\README.FPM.en.txt" "" "$INSTDIR\README.FPM.en.txt" 0
  CreateShortCut \
  	"$SMPROGRAMS\FreePOPs\Scripts\FreePOPs & Mail - Manuale (italiano).lnk"\
	"$INSTDIR\README.FPM.it.txt" "" "$INSTDIR\README.FPM.it.txt" 0

  ; doc + remove
  CreateShortCut "$SMPROGRAMS\FreePOPs\Uninstall.lnk" \
  	"$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Manual (english).lnk" \
  	"http://www.freepops.org/it/files/manual.pdf" \
	"" "http://www.freepops.org/" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Manuale (italiano).lnk" \
  	"http://www.freepops.org/it/files/manual-it.pdf" "" \
	"http://www.freepops.org/" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Website.lnk" \
  	"http://www.freepops.org/" "" \
	"http://www.freepops.org/" 0
  CreateShortCut "$SMPROGRAMS\FreePOPs\Forum.lnk" \
	  "http://www.diludovico.org/forum/" "" "http://www.diludovico.org/forum/" 0
SectionEnd

; uninstall stuff

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM \
  	"Software\Microsoft\Windows\CurrentVersion\Uninstall\FreePOPs"
  DeleteRegKey HKLM SOFTWARE\NSIS_FreePOPs
  ; remove files
  Delete $SYSDIR\lwel-manifest.dll
  Delete $INSTDIR\*.exe
  Delete $INSTDIR\*.dll
  Delete $INSTDIR\*.txt
  Delete $INSTDIR\*.pdf
  Delete $INSTDIR\*.lua
  Delete $INSTDIR\*.vbs
  Delete $INSTDIR\*.ico
  Delete $INSTDIR\LUA\*.lua
  Delete $INSTDIR\LUA\LXP\*.lua
  Delete $INSTDIR\LUA\BROWSER\*.lua
  Delete $INSTDIR\LUA\SOAP\*.lua
  Delete $INSTDIR\C\*.dll
  Delete $INSTDIR\LUA_UNOFFICIAL\*.lua
  Delete $INSTDIR\LUA_UPDATES\*.lua
  Delete $INSTDIR\LUA_UPDATES\LXP\*.lua
  Delete $INSTDIR\LUA_UPDATES\BROWSER\*.lua
  Delete $INSTDIR\LUA_UPDATES\SOAP\*.lua
  RMDir $INSTDIR\LUA\LXP
  RMDir $INSTDIR\LUA\SOAP
  RMDir $INSTDIR\LUA\BROWSER
  RMDir $INSTDIR\LUA
  RMDir $INSTDIR\C
  RMDir $INSTDIR\LUA_UNOFFICIAL
  RMDir $INSTDIR\LUA_UPDATES\LXP
  RMDir $INSTDIR\LUA_UPDATES\BROWSER
  RMDir $INSTDIR\LUA_UPDATES\SOAP
  RMDir $INSTDIR\LUA_UPDATES
  RMDir /r $INSTDIR\LANG
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\FreePOPs\*.*"
  Delete "$SMPROGRAMS\FreePOPs\Debug\*.*"
  Delete "$SMPROGRAMS\FreePOPs\Scripts\*.*"
  Delete "$SMPROGRAMS\FreePOPs\Service\*.*"
  ; remove directories used.
  RMDir "$SMPROGRAMS\FreePOPs\Debug"
  RMDir "$SMPROGRAMS\FreePOPs"
  RMDir "$INSTDIR"
SectionEnd

Function .onInit
 
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\FreePOPs" \
  "UninstallString"
  StrCmp $R0 "" done
 
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "FreePOPs is already installed. $\n$\nPlease close it, and click `OK` to remove the \
  previous version or `Cancel` to cancel this upgrade." \
  IDOK uninst
  Abort
  
;Run the uninstaller
uninst:
  ClearErrors
  Exec $INSTDIR\uninstall.exe
  
done:
 
FunctionEnd

; eof
