;
; Unwrap Thunk VBOX 4.3 (C) G-RoM in 2000
;
;
; Hydra example Plugin
;
;
; Started on    : 30th October 2000
; Latest update : 30th October 2000
;

		BITS 32

		%include "pedata.inc" ; Structs
		%include "memio.inc" ; Structs
		%include "vxdn.inc"

;
; Public definitions.
;
global UnwrapThunk			; Our export function
global _Start@12			; Main
;
; Code definition.
;
SEGMENT .text	USE32 CLASS=CODE
;
; Detect DLL Name of given thunk [Fast mode]
;

;
;esp+4 : IAT thunk
;esp+8 : DLL List
;
;eax=1 if member.
;
IsFromDLL:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	edx
	push	ecx
	push	ebx

	mov	esi, [ebp+0ch]		; DLLList
	mov	edx, [ebp+08h]		; Thunk
	xor	eax, eax		; RetVal
.LoopScan:
	cmp	[esi+DLLList.ModPath], eax             ; DLLList finished ?
	jz	.Failure

	mov	ebx, [esi+DLLList.Base] ; Thunk must be DLL Area
	cmp	edx, ebx
	jb	.CheckNextDLL
	add	ebx, [esi+DLLList.Size]
	cmp	edx, ebx
	jbe	.Success
.CheckNextDLL:
	add	esi, DLLList_size
	jmp	short .LoopScan
.Success:
	xor	eax, eax
	inc	eax
.Failure:
	pop	ebx
	pop	ecx
	pop	edx
	pop	edi
	pop	esi
	pop	ebp
	ret	08h
;
; Load ALL IAT thunk.
;

;
;esp+4 : ThunkSlot
;esp+8 : PE Buffer.
;esp+c : PE Infos.
;esp+10: DLL List.
;
;eax=thunk on success.
;
UnwrapThunk:
	push	ebp
	mov	ebp, esp

%define ThunkSlot ebp+08h
%define PEBuffer  ebp+0ch
%define PEInfos   ebp+10h
%define DLLList   ebp+14h

	push	edx
	push	esi
	push	edi
	push	ecx

;
; Init. Pointers.
;
	mov	edx, [PEInfos]
	mov	esi, [ThunkSlot]
	sub	esi, [PEBuffer]
	add	esi, [edx+PEStruc.ImageBase]	; Relocate

;
; Check Thunk Range.
;
.try_again:
	mov	eax, [esi]

	or	eax, eax
	jz	.ReturnEAX
	js	.ReturnEAX

	mov	esi, [ThunkSlot]
;
; Is this thunk a Direct DLL Member ?
;
	push	eax
	push	dword [DLLList]
	push	eax
	Call	IsFromDLL
	test	eax, eax
	pop	eax
	jnz	.ReturnEAX
;
; Check if valid memory.
;
	push	eax
	push	byte 9
	push	eax
	call	IsBadPtr
	or	eax,eax
	pop	eax
	jnz	.ReturnEAX
;
; Direct API Call ?
;
	cmp	byte [eax], 0xE8	; call rel32
	jnz	.ReturnEAX

	push	eax
	add	eax, [eax+1]
	add	eax, byte 5
	mov	[eax+06], byte 0x60		; pushad
	mov	[eax+43], dword 0xC358C961	; popad/leave/pop eax/ret
	pop	eax
	Call	eax
	
	mov	[esi], eax

	jmp	short .ReturnEAX
.ReadESI:
	mov	eax, [esi]
.ReturnEAX:
	pop	ecx
	pop	edi
	pop	esi
	pop	edx
	pop	ebp

%undef ThunkSlot
%undef PEBuffer
%undef PEInfos
%undef DLLList

	retn	10h

;
; DLLMAIN.
;

;
;
;
_Start@12:
	push	byte 01h
	pop	eax
	retn	0ch
