//////////////////////////////////////////////////////////////////////////////
// vmp3d.h
//
// Virtual MPEG Audio Layer3 Device header
//
// 11/09/1999	fOSSiL		Initial version
// 2000/07/03	The Owl		added GETSTATUSINFO

#ifndef VMP3D_INCL
#define VMP3D_INCL

#include <winioctl.h>

#if defined(__cplusplus)
	extern "C" {
#endif

#define MP3_PLAYWAVE_FUNC	1
#define MP3_SETLIST_FUNC	2
#define MP3_PLAY_FUNC		3
#define MP3_STOP_FUNC		4
#define MP3_PAUSE_FUNC		5
#define MP3_RESUME_FUNC		6
#define MP3_GETMPEGINFO_FUNC	7
#define MP3_GETSTREAMPTR_FUNC	8
#define MP3_SETSTREAMPTR_FUNC	9
#define MP3_GETSTATUSINFO_FUNC	10

#define MP3_PLAYWAVE		CTL_CODE(0, MP3_PLAYWAVE_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_SETLIST		CTL_CODE(0, MP3_SETLIST_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_PLAY		CTL_CODE(0, MP3_PLAY_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_STOP		CTL_CODE(0, MP3_STOP_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_PAUSE		CTL_CODE(0, MP3_PAUSE_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_RESUME		CTL_CODE(0, MP3_RESUME_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_GETMPEGINFO		CTL_CODE(0, MP3_GETMPEGINFO_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_GETSTREAMPTR	CTL_CODE(0, MP3_GETSTREAMPTR_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_SETSTREAMPTR	CTL_CODE(0, MP3_SETSTREAMPTR_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define MP3_GETSTATUSINFO	CTL_CODE(0, MP3_GETSTATUSINFO_FUNC, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct {
	LPCSTR lpFileName;
} MP3PLAYWAVE;

typedef struct {
	DWORD Count;
	DWORD NameOfs[0];
} MP3PLAYLIST;
#define ListStructSize(l)		(sizeof(l) + sizeof(l->NameOfs[0])*(l)->Count)
#define ListStringBuf(l)		(((char*)l) + ListStructSize(l))
#define ListNameOffset(l, n)	((n) - ((char*)l))

typedef struct {
	DWORD RetCode;
	DWORD Layer;
	DWORD Version;
	DWORD BitRate;
	DWORD Channels;
	DWORD SampFreq;
	DWORD ActChanels;
	DWORD ActSampFreq;
	DWORD BitsPerSample;
	DWORD FrameBits;
	DWORD StreamSize;
} MPEGINFO, *PMPEGINFO;

typedef struct {
	DWORD RetCode;
	DWORD Track;
	DWORD Progress;
	BYTE  IsPlaying;
	BYTE  IsBusy;
} STATUSINFO, *PSTATUSINFO;

#if defined(__cplusplus)
	}
#endif

#endif // VMP3D_INCL
