//////////////////////////////////////////////////////////////////////////////
// Playw32.h
//
// Win32 Interface to Virtual MPEG Device
//
// 09/11/1999	fOSSiL		Initial version
//

#ifndef PLAYW32_INCL
#define PLAYW32_INCL

#include "..\vxd\vmp3d.h"

#if defined(__cplusplus)
	extern "C" {
#endif

typedef struct {
	DWORD Layer;
	DWORD Version;
	DWORD BitRate;
	DWORD Chanels;
	DWORD SampFreq;
	DWORD ActChanels;
	DWORD ActSampFreq;
	DWORD BitsPerSample;
	DWORD FrameBits;
	DWORD StreamSize;
} MPEGSTREAMINFO, *PMPEGSTREAMINFO;

typedef struct {
	DWORD Track;
	DWORD Progress;
	BYTE  IsPlaying;
	BYTE  IsBusy;
} MPEGSTATUSINFO, *PMPEGSTATUSINFO;

typedef MP3PLAYLIST MPEGPLAYLIST, *PMPEGPLAYLIST;
#define MpegListSize(l)			ListStructSize(l)
#define MpegReqListSize(cf,ns)	(sizeof(MPEGPLAYLIST) + sizeof(DWORD)*cf + ns)
#define MpegListStringBuf(l)	ListStringBuf(l)
#define MpegListNameOfs(l, n)	ListNameOffset(l, n)

BOOL MpegOpenDevice();
BOOL MpegSetPlayList(MP3PLAYLIST* pList, DWORD ListSize);
BOOL MpegPlayFile(DWORD Index);
BOOL MpegStopPlay();
BOOL MpegPausePlay();
BOOL MpegResumePlay();
BOOL MpegGetStreamInfo(MPEGSTREAMINFO* pStream);
UINT MpegGetStreamPtr();
BOOL MpegSetStreamPtr(UINT Ptr);
BOOL MpegGetStatusInfo(MPEGSTATUSINFO* pStatus);
BOOL MpegCloseDevice();
DWORD MpegGetLastError();

#if defined(__cplusplus)
	}
#endif

#endif // PLAYW32_INCL
