%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"


global Parse_RDMSR
global Parse_WRMSR


extern sdata
extern Parser.errorMsg
extern ParseExpression


bits 32


segment _LTEXT
;-------------------------------------------------------------------------------
; RDMSR <MSR number>
;-------------------------------------------------------------------------------
Parse_RDMSR:
	mov	eax,[dCPUID_1_EDX]
	test	byte [eax],0x20
	jnz	@F

	mov	edi,Error_NoMSR
	jmp	Parser.errorMsg

@@
	mov	edi,Error_BadValue
	call	ParseExpression		; parse <MSR number>
	jb	near Parser.errorMsg

	mov	ecx,eax
	xor	eax,eax
	xor	edx,edx
	call	[pRDMSR]

	mov	edi,Error_BadMSR
	jc	near Parser.errorMsg

	push	eax
	push	edx
	push	ecx
	push	dword Format_ECX_EAX_EDX
	call	[pPrintf]
	add	esp,byte 16

	popad
	retn


;-------------------------------------------------------------------------------
; WRMSR <MSR number> <eax> [<edx>]
;-------------------------------------------------------------------------------
Parse_WRMSR:
	mov	eax,[dCPUID_1_EDX]
	test	byte [eax],0x20
	jnz	@F

	mov	edi,Error_NoMSR
	jmp	Parser.errorMsg

@@
	mov	edi,Error_BadValue
	call	ParseExpression		; parse <MSR number>
	jb	near Parser.errorMsg

	push	eax

	call	[pSkipWhiteSpace]	; skip to <eax>
	jnz	@F

	pop	eax
	mov	edi,Error_NoEAX
	jmp	Parser.errorMsg

@@
	call	ParseExpression		; parse <MSR number>
	jnb	@F

	pop	eax
	mov	edi,Error_BadEAX
	jmp	Parser.errorMsg

@@
	push	eax

	call	[pSkipWhiteSpace]	; skip to <eax>
	mov	eax,0
	jz	@F

	call	ParseExpression		; parse <MSR number>
	jnb	@F

	pop	eax
	pop	eax
	mov	edi,Error_BadEDX
	jmp	Parser.errorMsg

@@
	push	eax

	pop	edx
	pop	eax
	pop	ecx
	call	[pWRMSR]

	mov	edi,Error_BadMSR
	jc	near Parser.errorMsg

@@
	popad
	retn


segment _LDATA
Error_NoMSR:		db 'no MSR support on this CPU',0
Error_BadValue:		db 'cannot evaluate MSR number',0
Error_BadMSR:		db 'invalid MSR',0
Error_NoEAX:		db 'missing <eax>',0
Error_BadEAX:		db 'cannot evaluate <eax>',0
Error_BadEDX:		db 'cannot evaluate <edx>',0
Format_ECX_EAX_EDX:	db 'MSR: %08X   edx: %08X   eax: %08X',0
