%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"
%include "common.inc"


global Parser
global Parser.error
global Parser.errorMsg
global Parser.return


extern sdata
extern SaveRegs
extern RestoreRegs
extern Parse_Alloc
extern Parse_Bhrama
extern Parse_BreakR3
extern Parse_CDPlayer
extern Parse_Clip
extern Parse_Dump
extern Parse_FDump
extern Parse_FPU
extern Parse_Free
extern Parse_HaspCode
extern Parse_Help
extern Parse_Hydra
extern Parse_Kill
extern Parse_Load
extern Parse_MP3Player
extern Parse_Option
extern Parse_PageFlag
extern Parse_Pbpm
extern Parse_Pedump
extern Parse_Protect
extern Parse_RDMSR
extern Parse_Resume
extern Parse_ScreenDump
extern Parse_Suspend
extern Parse_SuspendX
extern Parse_Tetris
extern Parse_Trace
extern Parse_TraceX
extern Parse_WRMSR


bits 32


;-------------------------------------------------------------------------------
; this is the new parser that accepts the following syntax:
;
; ALLOC <address> <size>
; BHRAMA <Bhrama window name>
; BREAKR3 <R0TCB>
; CD [<track>]
; CLIP [AGPS [value]]
; DUMP <address> [<length> <file name>]
; FDUMP <RVA> <file name>
; FPU <FPU register number> <floating point value>
; FREE <address>
; HASPCODE <pwd1> <pwd2> <seed>
; HYDRA [<plugin name>]
; KILL <PID>
; LOAD <address> <length> <file name>
; MP3 [<track>]
; OPTION (Execute command for help)
; PAGEFLAG <address> pPrWsUcC
; PBPM [ON|OFF]
; PEDUMP <address> <entry RVA> <file name>
; PROTECT [ON|OFF]
; RDMSR <MSR number>
; RESUME <PID>|<TID>
; SCREENDUMP [<file>]
; SUSPEND <PID>|<TID>
; SUSPENDX <PID>|<TID>
; TETRIS [<speed>]
; TRACE [<R0TCB> [<EIP low> [<EIP high>]]]
; TRACEX <EIP low> [<EIP high>]
; WRMSR <MSR number> <eax> [<edx>]
;-------------------------------------------------------------------------------

segment _LTEXT
Parser:
	pushad

	call	SaveRegs		; save the client registers

	mov	esi,[bUserCommand]
	inc	esi			; skip over leading '/' or whatever

	mov	ebx,Commands-8

@@
	add	ebx,byte 8
	mov	edi,[ebx]
	or	edi,edi
	jz	near Parse_Help

	call	.stricmp
	jnz	@B

	call	[pSkipNonWhiteSpace]	; skip over command

	jmp	[ebx+4]

.errorMsg:
	mov	esi,edi
	call	[pPrintToCommandWindow]

.error:
	call	RestoreRegs		; restore the client registers

.return:
	popad
	retn


.stricmp:
	push	esi
	push	edi

@@
	lodsb
	xor	al,[edi]
	inc	edi
	and	al,~0x20
	jnz	@F

	cmp	byte [edi-1],0
	jnz	@B

@@
	pop	edi
	pop	esi
	retn


segment _LDATA
	align 4
Commands:
	dd .cmdALLOC,		Parse_Alloc
	dd .cmdBHRAMA,		Parse_Bhrama
	dd .cmdBREAKR3,		Parse_BreakR3
	dd .cmdCD,		Parse_CDPlayer
	dd .cmdCLIP,		Parse_Clip
	dd .cmdDUMP,		Parse_Dump
	dd .cmdFDUMP,		Parse_FDump
	dd .cmdFPU,		Parse_FPU
	dd .cmdFREE,		Parse_Free
	dd .cmdHASPCODE,	Parse_HaspCode
	dd .cmdHYDRA,		Parse_Hydra
	dd .cmdKILL,		Parse_Kill
	dd .cmdLOAD,		Parse_Load
	dd .cmdMP3,		Parse_MP3Player
	dd .cmdOPTION,		Parse_Option
	dd .cmdPAGEFLAG,	Parse_PageFlag
	dd .cmdPBPM,		Parse_Pbpm
	dd .cmdPEDUMP,		Parse_Pedump
	dd .cmdPROTECT,		Parse_Protect
	dd .cmdRDMSR,		Parse_RDMSR
	dd .cmdRESUME,		Parse_Resume
	dd .cmdSCREENDUMP,	Parse_ScreenDump
	dd .cmdSUSPEND,		Parse_Suspend
	dd .cmdSUSPENDX,	Parse_SuspendX
	dd .cmdTETRIS,		Parse_Tetris
	dd .cmdTRACE,		Parse_Trace
	dd .cmdTRACEX,		Parse_TraceX
	dd .cmdWRMSR,		Parse_WRMSR
	dd 0,0

.cmdALLOC:	db 'ALLOC',0
.cmdBHRAMA:	db 'BHRAMA',0
.cmdBREAKR3:	db 'BREAKR3',0
.cmdCD:		db 'CD',0
.cmdCLIP:	db 'CLIP',0
.cmdDUMP:	db 'DUMP',0
.cmdFDUMP:	db 'FDUMP',0
.cmdFPU:	db 'FPU',0
.cmdFREE:	db 'FREE',0
.cmdHASPCODE:	db 'HASPCODE',0
.cmdHYDRA:	db 'HYDRA',0
.cmdKILL:	db 'KILL',0
.cmdLOAD:	db 'LOAD',0
.cmdMP3:	db 'MP3',0
.cmdOPTION:	db 'OPTION',0
.cmdPAGEFLAG:	db 'PAGEFLAG',0
.cmdPBPM:	db 'PBPM',0
.cmdPEDUMP:	db 'PEDUMP',0
.cmdPROTECT:	db 'PROTECT',0
.cmdRDMSR:	db 'RDMSR',0
.cmdRESUME:	db 'RESUME',0
.cmdSCREENDUMP:	db 'SCREENDUMP',0
.cmdSUSPEND:	db 'SUSPEND',0
.cmdSUSPENDX:	db 'SUSPENDX',0
.cmdTETRIS:	db 'TETRIS',0
.cmdTRACE:	db 'TRACE',0
.cmdTRACEX:	db 'TRACEX',0
.cmdWRMSR:	db 'WRMSR',0
