/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.autobean.shared;

import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import com.google.gwt.autobean.shared.AutoBeanVisitor;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.ValueCodex;
import com.google.gwt.autobean.shared.impl.EnumMap;
import com.google.gwt.autobean.shared.impl.LazySplittable;
import com.google.gwt.autobean.shared.impl.StringQuoter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBeanCodex {
    public static <T> AutoBean<T> decode(AutoBeanFactory factory, Class<T> clazz, Splittable data) {
        return new Decoder(factory).decode(data, clazz);
    }

    public static <T> AutoBean<T> decode(AutoBeanFactory factory, Class<T> clazz, String payload) {
        Splittable data = StringQuoter.split(payload);
        return AutoBeanCodex.decode(factory, clazz, data);
    }

    public static Splittable encode(AutoBean<?> bean) {
        if (bean == null) {
            return LazySplittable.NULL;
        }
        StringBuilder sb = new StringBuilder();
        AutoBeanCodex.encodeForJsoPayload(sb, bean);
        return new LazySplittable(sb.toString());
    }

    private static void encodeForJsoPayload(StringBuilder sb, AutoBean<?> bean) {
        Encoder e = new Encoder(bean.getFactory());
        e.push(sb);
        try {
            bean.accept(e);
        }
        catch (HaltException ex) {
            throw ex.getCause();
        }
    }

    private AutoBeanCodex() {
    }

    static class HaltException
    extends RuntimeException {
        public HaltException(RuntimeException cause) {
            super(cause);
        }

        public RuntimeException getCause() {
            return (RuntimeException)super.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Encoder
    extends AutoBeanVisitor {
        private EnumMap enumMap;
        private Set<AutoBean<?>> seen = new HashSet();
        private Stack<StringBuilder> stack = new Stack();
        private StringBuilder sb;

        public Encoder(AutoBeanFactory factory) {
            if (factory instanceof EnumMap) {
                this.enumMap = (EnumMap)((Object)factory);
            }
        }

        @Override
        public void endVisit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            if (this.sb.length() == 0) {
                this.sb.append("{");
            } else {
                this.sb.setCharAt(0, '{');
            }
            this.sb.append("}");
        }

        @Override
        public void endVisitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            StringBuilder popped = this.pop();
            if (popped.length() > 0) {
                this.sb.append(",\"").append(propertyName).append("\":").append(popped.toString());
            }
        }

        @Override
        public boolean visitCollectionProperty(String propertyName, AutoBean<Collection<?>> value, AutoBeanVisitor.CollectionPropertyContext ctx) {
            this.push(new StringBuilder());
            if (value == null) {
                return false;
            }
            Collection<?> collection = value.as();
            if (collection.isEmpty()) {
                this.sb.append("[]");
                return false;
            }
            if (ValueCodex.canDecode(ctx.getElementType())) {
                for (Object element : collection) {
                    this.sb.append(",").append(this.encodeValue(ctx.getElementType(), element).getPayload());
                }
            } else {
                boolean isEncoded = Splittable.class.equals(ctx.getElementType());
                for (Object element : collection) {
                    this.sb.append(",");
                    if (element == null) {
                        this.sb.append("null");
                        continue;
                    }
                    if (isEncoded) {
                        this.sb.append(((Splittable)element).getPayload());
                        continue;
                    }
                    this.encodeToStringBuilder(this.sb, element);
                }
            }
            this.sb.setCharAt(0, '[');
            this.sb.append("]");
            return false;
        }

        @Override
        public boolean visitMapProperty(String propertyName, AutoBean<Map<?, ?>> value, AutoBeanVisitor.MapPropertyContext ctx) {
            this.push(new StringBuilder());
            if (value == null) {
                return false;
            }
            Map<?, ?> map = value.as();
            if (map.isEmpty()) {
                this.sb.append("{}");
                return false;
            }
            Class<?> keyType = ctx.getKeyType();
            Class<?> valueType = ctx.getValueType();
            boolean isEncodedKey = Splittable.class.equals(keyType);
            boolean isEncodedValue = Splittable.class.equals(valueType);
            boolean isValueKey = ValueCodex.canDecode(keyType);
            boolean isValueValue = ValueCodex.canDecode(valueType);
            if (isValueKey) {
                this.writeValueKeyMap(map, keyType, valueType, isEncodedValue, isValueValue);
            } else {
                this.writeObjectKeyMap(map, valueType, isEncodedKey, isEncodedValue, isValueValue);
            }
            return false;
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            this.push(new StringBuilder());
            if (value == null) {
                return false;
            }
            if (Splittable.class.equals(ctx.getType())) {
                this.sb.append(((Splittable)value.as()).getPayload());
                return false;
            }
            if (this.seen.contains(value)) {
                this.haltOnCycle();
            }
            return true;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            Class<?> type = ctx.getType();
            Object blankValue = ValueCodex.getUninitializedFieldValue(type);
            if (value == blankValue || value != null && value.equals(blankValue)) {
                return false;
            }
            Splittable split = this.encodeValue(type, value);
            this.sb.append(",\"").append(propertyName).append("\":").append(split.getPayload());
            return false;
        }

        StringBuilder pop() {
            StringBuilder toReturn = this.stack.pop();
            this.sb = this.stack.peek();
            return toReturn;
        }

        void push(StringBuilder sb) {
            this.stack.push(sb);
            this.sb = sb;
        }

        private void encodeToStringBuilder(StringBuilder accumulator, Object value) {
            this.push(new StringBuilder());
            AutoBean bean = AutoBeanUtils.getAutoBean(value);
            if (!this.seen.add(bean)) {
                this.haltOnCycle();
            }
            bean.accept(this);
            accumulator.append(this.pop().toString());
            this.seen.remove(bean);
        }

        private Splittable encodeValue(Class<?> expectedType, Object value) {
            Splittable split = value instanceof Enum && this.enumMap != null ? ValueCodex.encode(String.class, this.enumMap.getToken((Enum)value)) : ValueCodex.encode(expectedType, value);
            return split;
        }

        private void haltOnCycle() {
            throw new HaltException(new UnsupportedOperationException("Cycle detected"));
        }

        private void writeObjectKeyMap(Map<?, ?> map, Class<?> valueType, boolean isEncodedKey, boolean isEncodedValue, boolean isValueValue) {
            StringBuilder keys = new StringBuilder();
            StringBuilder values = new StringBuilder();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (isEncodedKey) {
                    keys.append(",").append(((Splittable)entry.getKey()).getPayload());
                } else {
                    this.encodeToStringBuilder(keys.append(","), entry.getKey());
                }
                if (isEncodedValue) {
                    values.append(",").append(((Splittable)entry.getValue()).getPayload());
                    continue;
                }
                if (isValueValue) {
                    values.append(",").append(this.encodeValue(valueType, entry.getValue()).getPayload());
                    continue;
                }
                this.encodeToStringBuilder(values.append(","), entry.getValue());
            }
            keys.setCharAt(0, '[');
            keys.append("]");
            values.setCharAt(0, '[');
            values.append("]");
            this.sb.append("[").append(keys.toString()).append(",").append(values.toString()).append("]");
        }

        private void writeValueKeyMap(Map<?, ?> map, Class<?> keyType, Class<?> valueType, boolean isEncodedValue, boolean isValueValue) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.sb.append(",").append(this.encodeValue(keyType, entry.getKey()).getPayload()).append(":");
                if (isEncodedValue) {
                    this.sb.append(((Splittable)entry.getValue()).getPayload());
                    continue;
                }
                if (isValueValue) {
                    this.sb.append(this.encodeValue(valueType, entry.getValue()).getPayload());
                    continue;
                }
                this.encodeToStringBuilder(this.sb, entry.getValue());
            }
            this.sb.setCharAt(0, '{');
            this.sb.append("}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Decoder
    extends AutoBeanVisitor {
        private final Stack<AutoBean<?>> beanStack = new Stack();
        private final Stack<Splittable> dataStack = new Stack();
        private AutoBean<?> bean;
        private Splittable data;
        private final AutoBeanFactory factory;

        public Decoder(AutoBeanFactory factory) {
            this.factory = factory;
        }

        public <T> AutoBean<T> decode(Splittable data, Class<T> type) {
            this.push(data, type);
            this.bean.accept(this);
            return this.pop();
        }

        @Override
        public boolean visitCollectionProperty(String propertyName, AutoBean<Collection<?>> value, AutoBeanVisitor.CollectionPropertyContext ctx) {
            AbstractCollection collection;
            if (this.data.isNull(propertyName)) {
                return false;
            }
            if (List.class.equals(ctx.getType())) {
                collection = new ArrayList();
            } else if (Set.class.equals(ctx.getType())) {
                collection = new HashSet();
            } else {
                throw new UnsupportedOperationException("Only List and Set supported");
            }
            boolean isValue = ValueCodex.canDecode(ctx.getElementType());
            boolean isEncoded = Splittable.class.equals(ctx.getElementType());
            Splittable listData = this.data.get(propertyName);
            int j = listData.size();
            for (int i = 0; i < j; ++i) {
                if (listData.isNull(i)) {
                    collection.add(null);
                    continue;
                }
                if (isValue) {
                    collection.add(this.decodeValue(ctx.getElementType(), listData.get(i)));
                    continue;
                }
                if (isEncoded) {
                    collection.add(listData.get(i));
                    continue;
                }
                collection.add(this.decode(listData.get(i), ctx.getElementType()).as());
            }
            ctx.set(collection);
            return false;
        }

        @Override
        public boolean visitMapProperty(String propertyName, AutoBean<Map<?, ?>> value, AutoBeanVisitor.MapPropertyContext ctx) {
            if (this.data.isNull(propertyName)) {
                return false;
            }
            Map<?, ?> map = ValueCodex.canDecode(ctx.getKeyType()) ? this.decodeValueKeyMap(this.data.get(propertyName), ctx.getKeyType(), ctx.getValueType()) : this.decodeObjectKeyMap(this.data.get(propertyName), ctx.getKeyType(), ctx.getValueType());
            ctx.set(map);
            return false;
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            if (this.data.isNull(propertyName)) {
                return false;
            }
            if (Splittable.class.equals(ctx.getType())) {
                ctx.set(this.data.get(propertyName));
                return false;
            }
            this.push(this.data.get(propertyName), ctx.getType());
            this.bean.accept(this);
            ctx.set(this.pop().as());
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            if (!this.data.isNull(propertyName)) {
                Splittable propertyValue = this.data.get(propertyName);
                Class<?> type = ctx.getType();
                Object object = this.decodeValue(type, propertyValue);
                ctx.set(object);
            }
            return false;
        }

        private Map<?, ?> decodeObjectKeyMap(Splittable map, Class<?> keyType, Class<?> valueType) {
            boolean isEncodedKey = Splittable.class.equals(keyType);
            boolean isEncodedValue = Splittable.class.equals(valueType);
            boolean isValueValue = Splittable.class.equals(valueType);
            Splittable keyList = map.get(0);
            Splittable valueList = map.get(1);
            assert (keyList.size() == valueList.size());
            HashMap<Splittable, Splittable> toReturn = new HashMap<Splittable, Splittable>(keyList.size());
            int j = keyList.size();
            for (int i = 0; i < j; ++i) {
                Splittable key = isEncodedKey ? keyList.get(i) : this.decode(keyList.get(i), keyType).as();
                Object value = valueList.isNull(i) ? null : (isEncodedValue ? keyList.get(i) : (isValueValue ? this.decodeValue(valueType, keyList.get(i)) : this.decode(valueList.get(i), valueType).as()));
                toReturn.put(key, (Splittable)value);
            }
            return toReturn;
        }

        private Object decodeValue(Class<?> type, Splittable propertyValue) {
            return this.decodeValue(type, propertyValue.asString());
        }

        private Object decodeValue(Class<?> type, String propertyValue) {
            Object object;
            if (type.isEnum() && this.bean.getFactory() instanceof EnumMap) {
                Object e;
                Class<?> enumType = type;
                object = e = ((EnumMap)((Object)this.bean.getFactory())).getEnum(enumType, propertyValue);
            } else {
                object = ValueCodex.decode(type, propertyValue);
            }
            return object;
        }

        private Map<?, ?> decodeValueKeyMap(Splittable map, Class<?> keyType, Class<?> valueType) {
            HashMap<Object, Splittable> toReturn = new HashMap<Object, Splittable>();
            boolean isEncodedValue = Splittable.class.equals(valueType);
            boolean isValueValue = ValueCodex.canDecode(valueType);
            for (String encodedKey : map.getPropertyKeys()) {
                Object key = this.decodeValue(keyType, encodedKey);
                Object value = map.isNull(encodedKey) ? null : (isEncodedValue ? map.get(encodedKey) : (isValueValue ? this.decodeValue(valueType, map.get(encodedKey)) : this.decode(map.get(encodedKey), valueType).as()));
                toReturn.put(key, (Splittable)value);
            }
            return toReturn;
        }

        private AutoBean<?> pop() {
            this.dataStack.pop();
            this.data = this.dataStack.isEmpty() ? null : this.dataStack.peek();
            AutoBean<?> toReturn = this.beanStack.pop();
            this.bean = this.beanStack.isEmpty() ? null : this.beanStack.peek();
            return toReturn;
        }

        private void push(Splittable data, Class<?> type) {
            this.data = data;
            this.bean = this.factory.create(type);
            if (this.bean == null) {
                throw new IllegalArgumentException("The AutoBeanFactory cannot create a " + type.getName());
            }
            this.dataStack.push(data);
            this.beanStack.push(this.bean);
        }
    }
}

