/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.autobean.server.AutoBeanFactoryMagic;
import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanCodex;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.ValueCodex;
import com.google.gwt.autobean.shared.impl.StringQuoter;
import com.google.gwt.requestfactory.server.Resolver;
import com.google.gwt.requestfactory.server.ServiceLayer;
import com.google.gwt.requestfactory.server.SimpleRequestProcessor;
import com.google.gwt.requestfactory.server.UnexpectedException;
import com.google.gwt.requestfactory.shared.BaseProxy;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.ValueProxy;
import com.google.gwt.requestfactory.shared.impl.EntityCodex;
import com.google.gwt.requestfactory.shared.impl.IdFactory;
import com.google.gwt.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.gwt.requestfactory.shared.impl.SimpleProxyId;
import com.google.gwt.requestfactory.shared.messages.IdMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestState
implements EntityCodex.EntitySource {
    final SimpleRequestProcessor.IdToEntityMap beans = new SimpleRequestProcessor.IdToEntityMap();
    private final Map<Object, SimpleProxyId<?>> domainObjectsToId;
    private final IdFactory idFactory;
    private final ServiceLayer service;
    private final Resolver resolver;

    public RequestState(RequestState parent) {
        this.idFactory = parent.idFactory;
        this.domainObjectsToId = parent.domainObjectsToId;
        this.service = parent.service;
        this.resolver = new Resolver(this);
    }

    public RequestState(final ServiceLayer service) {
        this.service = service;
        this.idFactory = new IdFactory(){

            @Override
            public boolean isEntityType(Class<?> clazz) {
                return EntityProxy.class.isAssignableFrom(clazz);
            }

            @Override
            public boolean isValueType(Class<?> clazz) {
                return ValueProxy.class.isAssignableFrom(clazz);
            }

            @Override
            protected <P extends BaseProxy> Class<P> getTypeFromToken(String typeToken) {
                return service.resolveClass(typeToken);
            }

            @Override
            protected String getTypeToken(Class<? extends BaseProxy> clazz) {
                return service.resolveTypeToken(clazz);
            }
        };
        this.domainObjectsToId = new IdentityHashMap();
        this.resolver = new Resolver(this);
    }

    public Splittable flatten(Object domainValue) {
        Splittable flatValue = ValueCodex.canDecode(domainValue.getClass()) ? ValueCodex.encode(domainValue) : new SimpleRequestProcessor(this.service).createOobMessage(Collections.singletonList(domainValue));
        return flatValue;
    }

    public <Q extends BaseProxy> AutoBean<Q> getBeanForPayload(SimpleProxyId<Q> id, Object domainObject) {
        AutoBean<Q> toReturn = (AutoBean<Q>)this.beans.get(id);
        if (toReturn == null) {
            toReturn = this.createProxyBean(id, domainObject);
        }
        return toReturn;
    }

    @Override
    public <Q extends BaseProxy> AutoBean<Q> getBeanForPayload(Splittable serializedProxyId) {
        IdMessage idMessage = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, IdMessage.class, serializedProxyId).as();
        AutoBean<? extends BaseProxy> toReturn = this.getBeansForPayload(Collections.singletonList(idMessage)).get(0);
        return toReturn;
    }

    public List<AutoBean<? extends BaseProxy>> getBeansForPayload(List<? extends IdMessage> idMessages) {
        ArrayList ids = new ArrayList(idMessages.size());
        for (IdMessage idMessage : idMessages) {
            SimpleProxyId<BaseProxy> id;
            if (IdMessage.Strength.SYNTHETIC.equals((Object)idMessage.getStrength())) {
                Class<? extends BaseProxy> clazz = this.service.resolveClass(idMessage.getTypeToken());
                id = this.idFactory.allocateSyntheticId(clazz, idMessage.getSyntheticId());
            } else {
                String decodedId = idMessage.getServerId() == null ? null : SimpleRequestProcessor.fromBase64(idMessage.getServerId());
                id = this.idFactory.getId(idMessage.getTypeToken(), decodedId, idMessage.getClientId());
            }
            ids.add(id);
        }
        return this.getBeansForIds(ids);
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public Splittable getSerializedProxyId(SimpleProxyId<?> stableId) {
        AutoBean<IdMessage> bean = MessageFactoryHolder.FACTORY.id();
        IdMessage ref = bean.as();
        ref.setTypeToken(this.service.resolveTypeToken(stableId.getProxyClass()));
        if (stableId.isSynthetic()) {
            ref.setStrength(IdMessage.Strength.SYNTHETIC);
            ref.setSyntheticId(stableId.getSyntheticId());
        } else if (stableId.isEphemeral()) {
            ref.setStrength(IdMessage.Strength.EPHEMERAL);
            ref.setClientId(stableId.getClientId());
        } else {
            ref.setServerId(SimpleRequestProcessor.toBase64(stableId.getServerId()));
        }
        return AutoBeanCodex.encode(bean);
    }

    public ServiceLayer getServiceLayer() {
        return this.service;
    }

    public SimpleProxyId<?> getStableId(Object domain) {
        return this.domainObjectsToId.get(domain);
    }

    @Override
    public boolean isEntityType(Class<?> clazz) {
        return this.idFactory.isEntityType(clazz);
    }

    @Override
    public boolean isValueType(Class<?> clazz) {
        return this.idFactory.isValueType(clazz);
    }

    private <Q extends BaseProxy> AutoBean<Q> createProxyBean(SimpleProxyId<Q> id, Object domainObject) {
        AutoBean<Q> toReturn = AutoBeanFactoryMagic.createBean(id.getProxyClass(), SimpleRequestProcessor.CONFIGURATION);
        toReturn.setTag("stableId", id);
        toReturn.setTag("domainObject", domainObject);
        this.beans.put(id, toReturn);
        return toReturn;
    }

    private List<AutoBean<? extends BaseProxy>> getBeansForIds(List<SimpleProxyId<?>> ids) {
        ArrayList domainClasses = new ArrayList(ids.size());
        ArrayList<Object> domainIds = new ArrayList<Object>(ids.size());
        ArrayList idsToLoad = new ArrayList();
        for (SimpleProxyId<?> id : ids) {
            Class<?> domainClass = this.service.resolveDomainClass(id.getProxyClass());
            if (this.beans.containsKey(id)) continue;
            if (id.isEphemeral() || id.isSynthetic()) {
                Object obj = this.service.createDomainObject(domainClass);
                if (obj == null) {
                    throw new UnexpectedException("Could not create instance of " + domainClass.getCanonicalName(), null);
                }
                AutoBean<?> bean = this.createProxyBean(id, obj);
                this.beans.put(id, bean);
                this.domainObjectsToId.put(obj, id);
                continue;
            }
            Splittable splittable = StringQuoter.split(id.getServerId());
            Class<?> param = this.service.getIdType(domainClass);
            Object domainParam = ValueCodex.canDecode(param) ? ValueCodex.decode(param, splittable) : new SimpleRequestProcessor(this.service).decodeOobMessage(param, splittable).get(0);
            domainClasses.add(this.service.resolveDomainClass(id.getProxyClass()));
            domainIds.add(domainParam);
            idsToLoad.add(id);
        }
        if (!domainClasses.isEmpty()) {
            assert (domainClasses.size() == domainIds.size() && domainClasses.size() == idsToLoad.size());
            List<Object> loaded = this.service.loadDomainObjects(domainClasses, domainIds);
            if (idsToLoad.size() != loaded.size()) {
                throw new UnexpectedException("Expected " + idsToLoad.size() + " objects to be loaded, got " + loaded.size(), null);
            }
            Iterator<Object> itLoaded = loaded.iterator();
            for (SimpleProxyId simpleProxyId : idsToLoad) {
                Object domain = itLoaded.next();
                this.domainObjectsToId.put(domain, simpleProxyId);
                AutoBean bean = this.createProxyBean(simpleProxyId, domain);
                this.beans.put(simpleProxyId, bean);
            }
        }
        ArrayList<AutoBean<? extends BaseProxy>> toReturn = new ArrayList<AutoBean<? extends BaseProxy>>(ids.size());
        for (SimpleProxyId<?> id : ids) {
            toReturn.add((AutoBean<? extends BaseProxy>)this.beans.get(id));
        }
        return toReturn;
    }
}

