/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.NoSuchElementException;

public class HTMLPanel
extends ComplexPanel {
    private static com.google.gwt.dom.client.Element hiddenDiv;

    public static String createUniqueId() {
        return Document.get().createUniqueId();
    }

    public HTMLPanel(String html) {
        this.setElement(Document.get().createDivElement());
        this.getElement().setInnerHTML(html);
    }

    public HTMLPanel(SafeHtml safeHtml) {
        this(safeHtml.asString());
    }

    public HTMLPanel(String tag, String html) {
        StringBuilder b = new StringBuilder();
        b.append('<').append(tag).append('>').append(html);
        b.append("</").append(tag).append('>');
        DivElement scratchDiv = Document.get().createDivElement();
        scratchDiv.setInnerHTML(b.toString());
        this.setElement(scratchDiv.getFirstChildElement());
        this.getElement().removeFromParent();
    }

    public void add(Widget widget) {
        this.add(widget, this.getElement());
    }

    public void add(Widget widget, String id) {
        Element elem = this.getElementById(id);
        if (elem == null) {
            throw new NoSuchElementException(id);
        }
        this.add(widget, (com.google.gwt.dom.client.Element)elem);
    }

    public void add(Widget widget, com.google.gwt.dom.client.Element elem) {
        Element clientElem = (Element)elem.cast();
        super.add(widget, clientElem);
    }

    public final void addAndReplaceElement(Widget widget, com.google.gwt.dom.client.Element toReplace) {
        Element clientElem = (Element)toReplace.cast();
        this.addAndReplaceElement(widget, clientElem);
    }

    @Deprecated
    public void addAndReplaceElement(Widget widget, Element toReplace) {
        widget.removeFromParent();
        this.getChildren().add(widget);
        toReplace.getParentNode().replaceChild(widget.getElement(), toReplace);
        this.adopt(widget);
    }

    public void addAndReplaceElement(Widget widget, String id) {
        Element toReplace = this.getElementById(id);
        if (toReplace == null) {
            throw new NoSuchElementException(id);
        }
        this.addAndReplaceElement(widget, (com.google.gwt.dom.client.Element)toReplace);
    }

    public Element getElementById(String id) {
        com.google.gwt.dom.client.Element elem = this.isAttached() ? Document.get().getElementById(id) : this.attachToDomAndGetElement(id);
        return (Element)elem.cast();
    }

    private com.google.gwt.dom.client.Element attachToDomAndGetElement(String id) {
        if (hiddenDiv == null) {
            hiddenDiv = Document.get().createDivElement();
            UIObject.setVisible(hiddenDiv, false);
            RootPanel.getBodyElement().appendChild(hiddenDiv);
        }
        com.google.gwt.dom.client.Element origParent = this.getElement().getParentElement();
        com.google.gwt.dom.client.Element origSibling = this.getElement().getNextSiblingElement();
        hiddenDiv.appendChild(this.getElement());
        com.google.gwt.dom.client.Element child = Document.get().getElementById(id);
        if (origParent != null) {
            origParent.insertBefore(this.getElement(), origSibling);
        } else {
            hiddenDiv.removeChild(this.getElement());
        }
        return child;
    }
}

