package org.inria.bmajwatcher.client.services;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface SchedulingServiceAsync {

	public static final SchedulingServiceAsync INSTANCE = GWT.create(SchedulingService.class);
	
	void createTrigger(String label, String cron, AsyncCallback<Boolean> callback);

	void deleteTrigger(String name, AsyncCallback<Void> callback);

	void renameTrigger(String oldName, String newName, AsyncCallback<Void> callback);

	void setCron(String name, String cron, AsyncCallback<Boolean> callback);

	void addBanksToTrigger(String bankName[], String triggerName,
			AsyncCallback<Void> callback);

	void removeBanksFromTrigger(String[] bankNames, String triggerName,
			AsyncCallback<Void> callback);

	void getJobs(AsyncCallback<Map<String, List<String>>> callback);

	void getJobsDates(Date current, int range,
			AsyncCallback<Map<Date, String>> callback);
}
