package org.inria.bmajwatcher.server.launcher;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.log4j.Logger;

/**
 * Launcher that runs commands on localhost.
 * 
 * @author rsabas
 *
 */
public class LocalLauncher implements Launcher {
	
	private String biomajRoot = null;
	private String scriptsPath = null;
	
	private Logger log = Logger.getLogger(LocalLauncher.class);
	
	
	/**
	 * LocalLauncher should only be created via LauncherFactory as only
	 * on localLauncher is kept for the application.
	 * 
	 * @param context
	 */
	protected LocalLauncher(ServletContext context) {
		biomajRoot = context.getInitParameter("BIOMAJ_ROOT");
		scriptsPath = context.getRealPath("/") + "/shellscripts";
	}
	
	@Override
	public boolean startUpdate(String bankName) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --update " + bankName;
		
		return executeCommand(cmd);
	}

	@Override
	public boolean startUpdateFromScratch(String bankName) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --update " + bankName + " --fromscratch";
		return executeCommand(cmd);
	}

	@Override
	public boolean stopUpdate(String bankName) {
		String cmd = "/bin/bash " + scriptsPath + "/stop_bmaj.sh " +
				biomajRoot + " " + bankName;
		return executeCommand(cmd);
	}
	
	@Override
	public boolean rebuild(String bankName) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --rebuild " + bankName;
		return executeCommand(cmd);
	}

	@Override
	public boolean startUpdateNew(String bankName) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --update " + bankName + " --new";
		return executeCommand(cmd);
	}
	
	@Override
	public boolean removeAll(String bankName, boolean keepProd) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --remove " + bankName + " --all";

		if (keepProd)
			cmd += " --keep-dir-prod";
		
		return executeCommand(cmd);
	}
	
	@Override
	public boolean removeDirs(List<String> paths, String bankName, boolean keepProd) {
		String cmd = "/bin/bash " + scriptsPath + "/exec_bmaj.sh " +
				biomajRoot + " --remove " + bankName + " --paths";
		
		for (String path : paths)
			cmd += " " + path;
		
		if (keepProd)
			cmd += " --keep-dir-prod";
		
		return executeCommand(cmd);
	}
	
	
	private boolean executeCommand(String cmd) {
		log.info("LocalLauncher::Command : " + cmd);
		try {	
			Runtime.getRuntime().exec(cmd);
			/*
			Process p = Runtime.getRuntime().exec(cmd);
			
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line = "";
			while ( (line = br.readLine()) != null) {
				System.out.println(line);
			}
			br.close();*/
//			process.waitFor();
		} catch (IOException ex) {
			log.error("Command error : " + ex);
			return false;
		}
		return true;
	}

}
