#include "rpggame.h"

namespace game
{
	void renderplayer(rpgent *d)
	{
		rpgchar *dc = d->getchar();
		int lastaction = dc->lastaction,
			anim = ANIM_ATTACK1,
			delay = 300,
			hold = ANIM_HOLD1|ANIM_LOOP;


		renderclient(d, d->model, NULL, hold, anim, delay, lastaction, d->state!=CS_DEAD ? 0 : dc->lastpain, d->temp.fade, true);
	}

	int lastprojemit = 0;
	bool emitparts = false;
	VARP(useflares, 0, 1, 1);

	void renderprojs(rpgent *d, bool mainpass)
	{
		rpgchar *dc = d->getchar();
		loopv(dc->projs)
		{
			projectile &p = *dc->projs[i];
			if(!rpgobj::effects.inrange(p.effect)) continue;
			projeffect *sfx = rpgobj::effects[p.effect];

			if(sfx->mdl)
			{
				float yaw, pitch;
				vectoyawpitch(p.d, yaw, pitch);
				rendermodel(&p.light, sfx->mdl, ANIM_MAPMODEL|ANIM_LOOP, p.o, yaw, pitch, MDL_SHADOW);
			}

			if (mainpass)
			{
				if(!sfx->mdl)
				{
					switch(sfx->projpart)
					{
						case PART_EXPLOSION:
						case PART_EXPLOSION_NO_GLARE:
							particle_fireball(p.o, sfx->projsize, sfx->projpart, 0, sfx->projcol, sfx->projsize);
							break;
						case PART_STREAK:
						case PART_LIGHTNING:
						{
							if(!emitparts) break;
							loopj(10)
							{
								float yaw = rnd(360), pitch = rnd(180) - 90;
								vec d;
								vecfromyawpitch(yaw, pitch, 1, 0, d);
								d.mul(sfx->projsize * 5); d.add(p.o);
								particle_flare(p.o, d, emitmillis + 17, sfx->trailpart, sfx->trailcol, sfx->projsize / 8.0f);
							}
							break;
						}
						default:
							particle_splash(sfx->projpart, 1, 1, p.o, sfx->projcol, sfx->projsize, p.radius, 1);
							break;
					}
				}
				if(sfx->flags & PFX_TRAIL)
					p.addtrail(emitparts);
				if(useflares && sfx->flags & PFX_DYNLIGHT && sfx->lightcolour > 0)
					regularlensflare(p.o, (sfx->lightcolour & 0xFF0000) >> 16, (sfx->lightcolour & 0xFF00) >> 8, sfx->lightcolour & 0xFF, false, false, sfx->lightradius * 5);

			}
		}
	}

	void renderitem(rpgent *d)
	{
		rendermodel(&d->light, d->model, ANIM_MAPMODEL|ANIM_LOOP, vec(d->o).sub(vec(0, 0, d->eyeheight)), (lastmillis%1800) / 5, 0, MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED);
	}

	void renderobject(rpgent *d)
	{
		rendermodel(&d->light, d->model, ANIM_MAPMODEL|ANIM_LOOP, vec(d->o).sub(vec(0, 0, d->eyeheight)), d->yaw, d->pitch, MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED);
	}

	void rendereffects(rpgent *d)
	{
		loopv(d->effects)
		{
			status &s = *d->effects[i];

			float potency = 1.0f;
			if((s.duration + s.startmillis - lastmillis) < (s.duration * .2f))
			{
				potency = (s.duration + s.startmillis - lastmillis) / (s.duration * .2f);
				if(potency<=0) continue;
			}

			//This just draws some visible effects to let the player know this individual is afflicted with particle cancer :D
			switch(s.type)
			{
				case STATUS_HEALTH:
				case STATUS_MOVE:
				case STATUS_STRENGTH:
				case STATUS_INTELLIGENCE:
				case STATUS_CHARISMA:
				case STATUS_ENDURANCE:
				case STATUS_AGILITY:
				case STATUS_LUCK:
				case STATUS_CRIT:
				case STATUS_HREGEN:
				case STATUS_MREGEN:
				case STATUS_FIRE:
				case STATUS_WATER:
				case STATUS_AIR:
				case STATUS_EARTH:
				case STATUS_MAGIC:
				case STATUS_SLASH:
				case STATUS_BLUNT:
				case STATUS_PIERCE:
				case STATUS_DISPELL:
				case STATUS_DOOM:
				case STATUS_REFLECT:
				case STATUS_INVIS:
					break;
				case STATUS_LIGHT:
					particle_fireball(d->abovehead(), 2 * potency, PART_EXPLOSION, 0, 0x997F4C, 2 * potency);
					if(useflares && potency >= 0.01) regularlensflare(d->abovehead(), 0x99, 0x7F, 0x4C, true, false, 100 * potency);
					break;
				case STATUS_DEATH:
					break;
			}
		}
	}

	void rendergame(bool mainpass)
	{
		startmodelbatches();
		emitparts = ((lastmillis - lastprojemit) >= emitmillis && mainpass);
		loopv(rpgobjs)
		{
			if(rpgobjs[i]->etype == ENT_CHAR) //always render projectiles
				renderprojs(rpgobjs[i], mainpass);

			if(rpgobjs[i]->temp.dist > rpgobjdist) continue; //the player is #0
			switch(rpgobjs[i]->etype)
			{
				case ENT_CHAR:
					if(i || isthirdperson()) renderplayer(rpgobjs[i]);
					if(mainpass) rendereffects(rpgobjs[i]);
					break;
				case ENT_ITEM:
				case ENT_SPELL:
					renderitem(rpgobjs[i]);
					break;
				case ENT_OBJECT:
					renderobject(rpgobjs[i]);
					break;
			}
		}

		entities::renderentities(mainpass);
		if(emitparts) lastprojemit = lastmillis;
		endmodelbatches();
	}
};
