package tijmp;

import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;

/** A profiler handler, so the actual profiler can be 
 *  on the other end of a socket or inside the same jvm.
 */
public interface ProfilerHandler {
    /** Submit a task for later evaluation. */
    void submitTask (Runnable r);
    
    /** Request that the jvm being profiled does a full gc */
    void runGC ();

    /** Request a heap dump.
     *  This will start the work, the response will be given to 
     *  the current ui later on.
     */
    void walkHeap ();

    /** Find all objects below the given object and show a summary. 
     *  The just starts a request, the response will be given to 
     *  the current ui handler later on.
     */
    void childObjectsSummary (Object o);

    /** Find the objects for a set of tags. 
     */
    Object[] getObjectsForTags (long[] tags);

    /** Find all entries of a given class.
     *  This method starts the request and the response will be
     *  given to the current ui handler later on.
     * @param clz the class to find instances for
     */
    void showInstances (Class<?> clz);

    /** Find all Strings
     *  This method starts the request and the response will be
     *  given to the current ui handler later on.
     */
    void showStrings ();

    /** Find owners for all objects of the given class.
     *  This method starts the request and the response will be
     *  given to the current ui handler later on.
     */
    void showOwners (Class<?> clz);

    /** Get the memory mx bean for the vm being profiled. 
     */
    MemoryMXBean getMemoryMXBean ();

    /** Get the memory pool mx beans for the vm being profiled. 
     */
    List<MemoryPoolMXBean> getMemoryPoolMXBeans ();

    /** Get the thread mx bean for the vm being profiled.
     */ 
    ThreadMXBean getThreadMXBean ();
}
