package tijmp.actions;

import java.awt.event.ActionEvent;
import tijmp.filter.RecursiveFilter;
import tijmp.ui.FilterConfig;

/** A class that sets the current filter to show one package
 *  and its sub packages.
 */
public class OnlyPackage extends FilterAction {
    private String pname;

    public OnlyPackage (FilterConfig fc, String pname) {
	super ("Show " + pname + " and sub package", fc);
	this.pname = pname;
    }

    public void actionPerformed (ActionEvent e) {
	RecursiveFilter rf = new RecursiveFilter (pname);
	getFilterConfig ().setFilter (rf);
    }
}
