package tijmp.ui;

/** A class that can turn a class name into human readable format.
 */
public class Translator {
    public static String translate (Class<?> c) {
	if (c.isPrimitive ()) {
	    if (c == Boolean.TYPE)
		return "boolean";
	    if (c == Character.TYPE)
		return "char";
	    if (c == Byte.TYPE)
		return "byte";
	    if (c == Short.TYPE)
		return "short";
	    if (c == Integer.TYPE)
		return "int";
	    if (c == Long.TYPE)
		return "long";
	    if (c == Float.TYPE)
		return "float";
	    if (c == Double.TYPE)
		return "double";
	    if (c == Void.TYPE)
		return "void";
	}
	if (c.isArray ()) {
	    Class<?> comp = c.getComponentType ();
	    return translate (comp) + "[]";
	}
	return c.getName ();
    }
}
