// ----------------------------------------------------------------------------
//
//  Copyright (C) 2006-2010 Fons Adriaensen <fons@kokkinizita.net>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// ----------------------------------------------------------------------------


#include <stdlib.h>
#include <stdio.h>
#include "styles.h"
#include "global.h"
#include "typewin.h"


Typewin::Typewin (X_rootwin *parent, X_callback *callb, X_resman *xres, int xp, int yp) :
    X_window (parent, xp, yp, XSIZE, YSIZE, XftColors [C_MAIN_BG]->pixel),
    _callb (callb),
    _rcoeff (this, this),
    _rh_ord (this, this),
    _rv_ord (this, this),
    _rnband (this, this)
{
    X_hints hints;

    _atom = XInternAtom (dpy (), "WM_DELETE_WINDOW", True);
    XSetWMProtocols (dpy (), win (), &_atom, 1);
    _atom = XInternAtom (dpy (), "WM_PROTOCOLS", True);

    hints.position (xp, yp);
    hints.minsize (XSIZE, YSIZE);
    hints.maxsize (XSIZE, YSIZE);
    x_apply (&hints); 
    x_set_title (xres->get (".title", "AmbDec - New configuration"));

    (new X_textln (this, &Tst2,  20, 15, 115, 18, "Matrix scaling", -1))->x_map ();
    (new X_textln (this, &Tst2, 150, 15, 115, 18, "Horizontal. order", -1))->x_map ();
    (new X_textln (this, &Tst2, 280, 15, 115, 18, "Vertical. order", -1))->x_map ();
    (new X_textln (this, &Tst2, 410, 15, 115, 18, "Frequency bands", -1))->x_map ();
    _rcoeff.init (&Bst1, &Tst1, _rcoeff_text, 3,  20, 37, 115, 18, 0);
    _rh_ord.init (&Bst1, &Tst1, _rh_ord_text, 3, 150, 37, 115, 18, 0);
    _rv_ord.init (&Bst1, &Tst1, _rv_ord_text, 3, 280, 37, 115, 18, 0);
    _rnband.init (&Bst1, &Tst1, _rbands_text, 2, 410, 37, 115, 18, 0);
    _rcoeff.set_stat (2);
    _rh_ord.set_stat (0);
    _rv_ord.set_stat (0);
    _rnband.set_stat (0);

    (new X_textln (this, &Tst1, 20, 110, 80, 17, "Speakers", 0))->x_map ();
    _tnspkr = new X_textip (this, this, &Tst0, 105, 110, 40, 17, 3);
    _tnspkr->set_text ("4");
    _tnspkr->x_map ();

    Bst0.size.x = 70;
    Bst0.size.y = 18;
    _bcancel = new X_tbutton (this, this, &Bst0, 330, 125, "Cancel", 0, B_CANCEL);
    _bcancel->x_map ();
    _bcreate = new X_tbutton (this, this, &Bst0, 400, 125, "Create", 0, B_CREATE);
    _bcreate->x_map ();
}

 
Typewin::~Typewin (void)
{
}

 
void Typewin::handle_event (XEvent *E)
{
    switch (E->type)
    {
    case ClientMessage:
	clmesg ((XClientMessageEvent *) E);
	break;
    }
}


void Typewin::clmesg (XClientMessageEvent *E)
{
    if (E->message_type == _atom) x_unmap ();
}


void Typewin::handle_callb (int type, X_window *W, XEvent */*E*/)
{
    X_button *B;

    switch (type)
    {
    case X_callback::TEXTIP | X_textip::BUT:
	_tnspkr->enable ();
	break;
    case X_callback::BUTTON | X_button::RELSE:
	B = (X_button *) W;
	switch (B->cbid ())
	{
	case B_CANCEL:
	    x_unmap ();
	    break;
	case B_CREATE:
	    checkpar ();
	    break;
	}
	break;
    }
}


void Typewin::checkpar (void)
{
    if (_rv_ord.stat () > _rh_ord.stat () + 1)
    {
        _rv_ord.set_stat (_rh_ord.stat () + 1);
	return;
    }
    if ((_rh_ord.stat () == 2) && (_rv_ord.stat () > 1))
    {
        _rv_ord.set_stat (1);
	return;
    }
    if ((sscanf (_tnspkr->text (), "%d", &_nspkr) != 1) || (_nspkr < 4) || (_nspkr > MAXOP))
    {
	_tnspkr->set_text ("???");
	_tnspkr->enable ();
        return;
    }

    if (_callb) _callb->handle_callb (CB_CONF_NEW, this, 0);
    x_unmap ();
}


const char *Typewin::_rcoeff_text [3] = 
{
    "N3D",
    "SN3D",
    "Furse-Malham"
};

const char *Typewin::_rh_ord_text [3] = 
{
    "First order",
    "Second order",
    "Third order"
};

const char *Typewin::_rv_ord_text [3] = 
{
    "Horizontal only",
    "First order",
    "Second order"
};

const char *Typewin::_rbands_text [2] = 
{
    "Single band",
    "Dual band"
};


