
#ifndef __DEBUG_H__
#define __DEBUG_H__

#include "acfg.h"
#include "aclogger.h"

#ifndef SPAMLEVEL
#define SPAMLEVEL 10
#endif

#ifdef DEBUG

#include <meta.h>
#include <assert.h>
#define ASSERT(x) { if(acfg::debug > SPAMLEVEL*2) assert(x); }

/*
#define ldbg_always(x) { const char *p=strrchr(__FILE__, cPathSep); \
	p=p?(p+1):__FILE__; MYSTD::ostringstream __oss;\
	__oss << p <<":"<<__LINE__ <<"("<< pthread_self() \
			<< ") | "<< x; aclog::err(__oss.str().c_str());}
			*/
#define LOGSTART(x) t_logger __logobj(x);
#define LOG(x) { __logobj.GetFmter() << x; __logobj.Write(__FILE__,__LINE__); }
#define LOGSTART2(x, y) t_logger __logobj(x); LOG(y);
#define USRDBG(v, x) { if((v)<=acfg::debug) {LOG(x);} }
#define ldbg(x) { USRDBG(SPAMLEVEL, x); }

#define dbgline { ldbg("mark" /*__FILE__ << ": " << __LINE__*/); }

#elif defined(NOLOGATALL)

#define ldbgvl(v, x)
#define dbglvl(v)
#define ldbg(x)
#define dbgline
#define ASSERT(x)
#define USRDBG(v, x)
#define LOG(x)
#define LOGSTART(x)
#define LOGSTART2(x,y)

#else

#include <iostream>

#define ldbgvl(v, x)
#define dbglvl(v)
#define ldbg(x)
#define dbgline
#define ASSERT(x)
#define USRDBG(v, x) { if((v)<=acfg::debug) aclog::err( tSS()<<x ); }
#define LOG(x)
#define LOGSTART(x)
#define LOGSTART2(x,y)
#endif


#endif // __DEBUG_H__
