
#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>
#include <set>

//#include <netinet/in.h>
//#include <netdb.h>

//#include "tcpconnect.h"

#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class tDlJob;


class dlcon : public lockable
{ 
    public:
        dlcon(bool bManualExecution, mstring *xff=NULL);
        ~dlcon();

        void WorkLoop();
        
        void SignalStop();

	    void AddJob(tFileItemPtr m_pItem, tHttpUrl hi);
        void AddJob(tFileItemPtr m_pItem, 
        		acfg::tRepoData *pBackends, const mstring & sPatSuffix);
    	void EnqJob(tDlJob *);

        mstring m_sXForwardedFor;
        
    private:

    	//not to be copied
    	dlcon & operator=(const dlcon&);
    	dlcon(const dlcon&);
    	
    	friend class tDlJob;
    	
    	MYSTD::list<tDlJob*> m_qToReceive;
    	int m_wakepipe[2];

    	acbuf m_InBuf;
    	
    	// flags and local copies for input parsing
    	/// remember being attached to an fitem

    	bool m_bStopWhenIdle;

    	/// shared blacklist for bad hosts
    	MYSTD::set<mstring> m_MirrorHostBlacklist;

    	//! will establish the connection, keep its object pointer
    	//! in m_pConnection and return its file descriptor (negative on failure)
//    	int Connect(cmstring & sHostname, mstring &sErrOut);

};

typedef MYSTD::list<tDlJob*>::iterator dljIter; 

#endif


