/*
 * tcpconnect.h
 *
 *  Created on: 27.02.2010
 *      Author: ed
 */

#ifndef TCPCONNECT_H_
#define TCPCONNECT_H_

class tcpconnect
{
public:
	virtual ~tcpconnect();

	static SHARED_PTR<tcpconnect> Create(cmstring &sHostnameHint);
	static SHARED_PTR<tcpconnect> CreateConnected(cmstring &sHostname, mstring &sErrOut);
	/// Moves the connection handle to the reserve pool (resets the specified sptr).
	/// Shold only be supplied with IDLE connection handles in a sane state.
	static void RecycleIdleConnection(SHARED_PTR<tcpconnect> & handle);
	static time_t ExpireCache();

	inline int GetFD() { return m_conFd; }
	inline cmstring & GetHostname() { return m_sHostName; }
	inline void SetStateObserver(acfg::tRepoData::IHookHandler *pObs) { m_pConnStateObserver=pObs;}
	const tHttpUrl * GetProxyData() const { return m_proxy; }

	bool Connect(const mstring & sHostname, mstring &sErrOut);
	void Disconnect();

protected:
	tcpconnect operator=(const tcpconnect&);
	tcpconnect(const tcpconnect&);
	tcpconnect();

	int m_conFd;
	mstring m_sHostName;

	tHttpUrl * m_proxy;
	time_t m_nExpTime;

	acfg::tRepoData::IHookHandler *m_pConnStateObserver;
};

typedef SHARED_PTR<tcpconnect> tTcpHandlePtr;

#endif /* TCPCONNECT_H_ */
