; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "bibus"
!define PRODUCT_VERSION "1.5.2"
!define PRODUCT_WEB_SITE "http://bibus-biblio.sourceforge.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\bibusStart.pyw"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; Variables
Var USER   ; user type returned by UserInfo
Var PYTHON ; path to python.exe, usually C:\Program Files\Python23\python.exe
Var PYTHONW ; path to pythonw.exe, usually C:\Program Files\Python23\pythonw.exe
Var OOoPath ; path to UNO, usually C:\Program Files\OpenOffice.org 2\program
Var OOoURE ; path to URE in OOo3, usually C:\Program Files\OpenOffice.org 3\URE\lib
Var OOoBasis ; path to Basis in OOo3, usually C:\Program Files\OpenOffice.org 3\Basis\program
; Variables for Function checkInstall. We must define them here because the unix
; makensis command does not understand Var /GLOBAL <name> inside a function
   Var CHECK_ERROR
   Var PYTHON_RESULT 
   Var OOo_RESULT  
   Var WXVERSION
   Var PYMYSQL_VERSION
   Var win32com
   Var hwnd
   Var hwnd_btn
   var result
; additional variables for wp.ini
;   Var radio_OOo
;   Var radio_Word
;   Var radio_None
; bibus.config file
   Var bibusConfig

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "WinMessages.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Changing images
!define MUI_WELCOMEFINISHPAGE_BITMAP bibusWelcome.bmp
;!define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_UNWELCOMEFINISHPAGE_BITMAP bibusWelcome.bmp
;!define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP bibusHeaderImage.bmp
;!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\Docs\copying"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "bibus"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Check for needed extentions using a personal page created with InstallOptions
page custom checkInstall ""
; Ask about Custom types
page custom types save_types
; Ask about Custom fields
page custom fields save_fields
; Ask user what Word Processor to use
; page custom wp wp_leave
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!define MUI_FINISHPAGE_RUN "" ;"$INSTDIR\bibusStart.pyw"
;!define MUI_FINISHPAGE_RUN_FUNCTION run_bibus ; not a good idea because we are usually logged as Admin
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\Docs\release_notes.txt"
;!define MUI_FINISHPAGE_SHOWREADME_TEXT "Changelog"
!define MUI_FINISHPAGE_LINK "Bibus Web site"
!define MUI_FINISHPAGE_LINK_LOCATION http://bibus-biblio.sourceforge.net
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "Spanish"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}-Win32-Setup.exe"
InstallDir "$PROGRAMFILES\bibus"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "checkInstall.ini" ; loading the InstallOptions checkInstall page
  ;!insertmacro MUI_INSTALLOPTIONS_EXTRACT "wp.ini"
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "types.ini"
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "fields.ini"

  ; We first check if we are Admin or not
  UserInfo::GetAccountType
  Pop $USER
  ; we display a Warning to user in case he his not Admin
  StrCmp $USER "Admin" +2
  MessageBox MB_OK|MB_ICONINFORMATION \
  "Bibus will be install for the current user only. \
  If you want to install it for all the users, \
  please start the installer with Adminstrator rights."
  
  ; bibus.config file
  GetTempFileName $bibusConfig
  File "/oname=$bibusConfig" .\bibus.config
  ; MessageBox MB_OK "$bibusConfig"
   
  ; we first try to remove the old install before installing the new version
  ReadRegStr $R0 HKLM "${PRODUCT_UNINST_KEY}" "UninstallString"
  StrCmp $R0 "" done

  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "${PRODUCT_NAME} is already installed. $\n$\nClick `OK` to remove the \
  previous version or `Cancel` to cancel this upgrade." \
  IDOK uninst
  Abort
   
;Run the uninstaller
uninst:
  ClearErrors
  ; Copy the uninstaller to a temp location
  GetTempFileName $0
  CopyFiles $R0 $0
  ;Start the uninstaller using the option to not copy itself
  ExecWait '$0 _?=$INSTDIR'

  IfErrors no_remove_uninstaller
    ; In most cases the uninstall is successful at this point.
    ; You may also consider using a registry key to check whether
    ; the user has chosen to uninstall. If you are using an uninstaller
    ; components page, make sure all sections are uninstalled.
    goto done
  no_remove_uninstaller:
    MessageBox MB_ICONEXCLAMATION \
    "Unable to remove previous version of ${PRODUCT_NAME}"
    Abort

done:
  ; remove the copied uninstaller
  Delete '$0'

FunctionEnd

;Function run_bibus
;   nsExec::Exec `$PYTHONW "$INSTDIR\bibusStart.pyw"`
;FunctionEnd

Function checkInstall
   !insertmacro MUI_HEADER_TEXT "Checking" "Checking for needed extensions. Please wait."
   !insertmacro MUI_INSTALLOPTIONS_INITDIALOG 'checkInstall.ini'
   pop $hwnd ; handle to the window.
   GetDlgItem $hwnd_btn $HWNDPARENT 1 ; This returns a handle to the NEXT button.
   EnableWindow $hwnd_btn 0 ; this should disable the next button.
   ; getting the ListBox handle
   GetDlgItem $result $hwnd 1200
   
   ; Required extensions
   SendMessage $result ${LB_ADDSTRING} 0 "STR:REQUIRED EXTENSIONS"
   StrCpy $CHECK_ERROR "noError"
   ; python2.3
   ReadRegStr $0 HKLM "SOFTWARE\Python\PythonCore\2.6\InstallPath" ""
   StrCpy $PYTHON "$0\python.exe"
   StrCpy $PYTHONW "$0\pythonw.exe"
   StrCmp $0 "" +3 0
        StrCpy $PYTHON_RESULT "    OK: Python2.6 found in registry"
        Goto +3
        StrCpy $PYTHON_RESULT "    Error: Python2.6 not found in registry"
        StrCpy $CHECK_ERROR "Error"
   SendMessage $result ${LB_ADDSTRING} 0 'STR:$PYTHON_RESULT'
   ; wxpython
   nsExec::ExecToStack `"$PYTHON" -c "exec('try:\n import wx,sys\n if wx.VERSION > (2,8):\n  sys.stdout.write(wx.VERSION_STRING)\n else:\n  sys.stdout.write(\'0\')\nexcept ImportError:\n  sys.stdout.write(\'no wx\')')"`
      Pop $0  ; Return value/error/timeout
      Pop $1  ; Result
      StrCmp $0 0 0 +11
         StrCmp $1 "no wx" 0 +4
            StrCpy $WXVERSION "    Error: wxPython not found"
            StrCpy $CHECK_ERROR "Error"
            Goto +9
            StrCmp $1 0 0 +4
                StrCpy $WXVERSION "    Error: wxPython version is too old. Bibus requires wxPython 2.8."
                StrCpy $CHECK_ERROR "Error"
                Goto +5
                StrCpy $WXVERSION "    OK: wxPython found. Version = $1"
                Goto +3
        StrCpy $WXVERSION "    Error: wxPython not found"
        StrCpy $CHECK_ERROR "Error"
   SendMessage $result ${LB_ADDSTRING} 0 'STR:$WXVERSION'
   
   ; Optional extensions
   SendMessage $result ${LB_ADDSTRING} 0 'STR:'
   SendMessage $result ${LB_ADDSTRING} 0 'STR:OPTIONAL EXTENSIONS'
   ; python-MySQL
   StrCpy $PYMYSQL_VERSION "    Warning: Python-MySQL not found"
   nsExec::ExecToStack '"$PYTHON" -c "import MySQLdb,sys; sys.stdout.write(repr(MySQLdb.version_info))"'
      Pop $0  ; Return value/error/timeout
      Pop $1  ; Result
      StrCmp $0 0 0 +2
          StrCpy $PYMYSQL_VERSION "    OK: Python-MySQL found. Version = $1"
   SendMessage $result ${LB_ADDSTRING} 0 'STR:$PYMYSQL_VERSION'
   
   ; OOo extension
   SendMessage $result ${LB_ADDSTRING} 0 "STR:"
   SendMessage $result ${LB_ADDSTRING} 0 "STR:OPENOFFICE.ORG CONNECTION"
   ; OpenOffice.org2-uno
   ReadRegStr $OOoPath HKLM "SOFTWARE\OpenOffice.org\UNO\InstallPath" ""
   StrCpy $OOo_RESULT "    Warning: OpenOffice.org not found in registry"
   StrCmp $OOoPath "" +2 0
        StrCpy $OOo_RESULT "    OK: OpenOffice.org found in registry"
   SendMessage $result ${LB_ADDSTRING} 0 'STR:$OOo_RESULT'
   ; OOo URE for OOo3
   ReadRegStr $OOoURE HKLM "SOFTWARE\OpenOffice.org\Layers\OpenOffice.org\3" "UREINSTALLLOCATION"
   ; OOo Basis for OOo3
   ReadRegStr $OOoBasis HKLM "SOFTWARE\OpenOffice.org\Layers\OpenOffice.org\3" "BASISINSTALLLOCATION"

   ; MS Word extension
   SendMessage $result ${LB_ADDSTRING} 0 "STR:"
   SendMessage $result ${LB_ADDSTRING} 0 "STR:MICROSOFT WORD CONNECTION"
   ; win32com
   StrCpy $win32com "    Warning: win32com not found"
   nsExec::ExecToStack '"$PYTHON" -c "import win32com"'
      Pop $0  ; Return value/error/timeout
      Pop $1  ; Result
      StrCmp $0 0 0 +2
          StrCpy $win32com "    OK: win32com found."
   SendMessage $result ${LB_ADDSTRING} 0 'STR:$win32com'

   ; disable Next button in case of error
   StrCmp $CHECK_ERROR "Error" 0 +4
       MessageBox MB_OK|MB_ICONSTOP "Some extensions required by bibus are not installed. Please install the program/packages marked 'Error' above and re-run this installer."
       EnableWindow $hwnd_btn 0 ; this should disable the next button.
       Goto +2
       EnableWindow $hwnd_btn 1 ; this enable the next button.
   !insertmacro MUI_INSTALLOPTIONS_SHOW
FunctionEnd

Function types
   !insertmacro MUI_HEADER_TEXT "Database" "Custom reference types"
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "types.ini"
FunctionEnd

Function save_types
   !insertmacro MUI_INSTALLOPTIONS_READ $R1 "types.ini" "Field 1" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R2 "types.ini" "Field 2" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R3 "types.ini" "Field 3" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R4 "types.ini" "Field 4" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R5 "types.ini" "Field 5" "State"
   ; now we write bibus.config
   FileOpen $3 "$bibusConfig" a
   FileSeek $3 0 END
   StrCmp $R1 "CUSTOM1" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM1'] = u'$R1'$\r$\n"
   StrCmp $R2 "CUSTOM2" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM2'] = u'$R2'$\r$\n"
   StrCmp $R3 "CUSTOM3" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM3'] = u'$R3'$\r$\n"
   StrCmp $R4 "CUSTOM4" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM4'] = u'$R4'$\r$\n"
   StrCmp $R5 "CUSTOM5" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM5'] = u'$R5'$\r$\n"
   FileClose $3
FunctionEnd

Function fields
   !insertmacro MUI_HEADER_TEXT "Database" "Custom reference fields"
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "fields.ini"
FunctionEnd

Function save_fields
   !insertmacro MUI_INSTALLOPTIONS_READ $R1 "fields.ini" "Field 1" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R2 "fields.ini" "Field 2" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R3 "fields.ini" "Field 3" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R4 "fields.ini" "Field 4" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R5 "fields.ini" "Field 5" "State"
   ; now we write bibus.config
   FileOpen $3 "$bibusConfig" a
   FileSeek $3 0 END
   StrCmp $R1 "Custom1" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom1'] = u'$R1'$\r$\n"
   StrCmp $R2 "Custom2" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom2'] = u'$R2'$\r$\n"
   StrCmp $R3 "Custom3" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom3'] = u'$R3'$\r$\n"
   StrCmp $R4 "Custom4" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom4'] = u'$R4'$\r$\n"
   StrCmp $R5 "Custom5" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom5'] = u'$R5'$\r$\n"
   FileClose $3
FunctionEnd

;Function wp
;   !insertmacro MUI_HEADER_TEXT "Connection" "Word Processor settings"
;   !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "wp.ini"
;   pop $hwnd ; handle to the window.
;   ; getting the radio_btn handles
;   GetDlgItem $radio_OOo $hwnd 1200
;   GetDlgItem $radio_Word $hwnd 1201
;   GetDlgItem $radio_None $hwnd 1202
;   ; Disable not needed radio_buttons according to available extensions
;   StrCmp $OOo_RESULT "    OK: OpenOffice.org2 found in registry" +2 0
;      EnableWindow $radio_OOo 0 ; disable OOo button
;   StrCmp $win32com "    OK: win32com found." +2 0
;      EnableWindow $radio_Word 0
;   ; we select by default the first enabled button
;   StrCmp $OOo_RESULT "    OK: OpenOffice.org2 found in registry" 0 +3
;      SendMessage $radio_OOo ${BM_SETCHECK} 1 0
;      Goto +5
;      StrCmp $win32com "    OK: win32com found." 0 +3
;         SendMessage $radio_Word ${BM_SETCHECK} 1 0
;         Goto +2
;      SendMessage $radio_None ${BM_SETCHECK} 1 0
;   !insertmacro MUI_INSTALLOPTIONS_SHOW
;FunctionEnd

;Function wp_leave
;   ; we get the state of the radio_buttons
;   SendMessage $radio_OOo ${BM_GETCHECK} 0 0 $0
;   SendMessage $radio_Word ${BM_GETCHECK} 0 0 $1
;   SendMessage $radio_None ${BM_GETCHECK} 0 0 $2
;   ; now we write bibus.config
;   FileOpen $3 $bibusConfig a
;   FileSeek $3 0 END
;   FileWrite $3 "# setting default connection mode depending on the choices during installation$\n"
;   StrCmp $0 1 0 +3
;      FileWrite $3 "BIBbase.WP = 'OOo'"
;      Goto +5
;      StrCmp $1 1 0 +3
;         FileWrite $3 "BIBbase.WP = 'mswDoc'"
;         Goto +2
;      FileWrite $3 "BIBbase.WP = ''"
;    FileWrite $3 "$\n"
;    FileClose $3
;FunctionEnd

Section "bibus" SEC01
  SectionIn RO
  SetOverwrite try
  SetOutPath "$INSTDIR"
  
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
  
  ; Put file there
  File /r /x Setup /x Freeze ..\*.py
  File /r /x Setup /x Freeze ..\*.png
  File /r /x CVS ..\db_models ..\locale
  File ..\MySQL_Bibus.ini ..\bibusStart.pyw
  CreateDirectory Pixmaps
  File /oname=Pixmaps\bibus.ico ..\Pixmaps\bibus.ico
  ; bibus.config = file in WinInstaller + variables set in wp_leave
  ; File /oname=bibus.config bibus.config
  Rename "$bibusConfig" "$INSTDIR\bibus.config"
  File /oname=StyleEditor\default_style ..\StyleEditor\default_style
  CreateDirectory $INSTDIR\Setup
  File /oname=Setup\UnoConnectionListener.odg ..\Setup\UnoConnectionListener.odg
  CreateDirectory $INSTDIR\Data
  File /oname=Data\journals.csv ..\Data\journals.csv

; copying styles
; CreateDirectory $INSTDIR\Format\Styles
  SetOutPath $INSTDIR\Format
  File /r /x CVS ..\Format\Styles

; generating and writing bibus.cfg file
  SetOutPath $INSTDIR
  WriteINIStr $INSTDIR\bibus.cfg PATH python $PYTHONW
  WriteINIStr $INSTDIR\bibus.cfg PATH oopath $OOoPath
  WriteINIStr $INSTDIR\bibus.cfg PATH ooure "$OOoUREbin"
  WriteINIStr $INSTDIR\bibus.cfg PATH oobasis "$OOoBasisprogram"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section "Documentation (English)" SEC02
  SetOutPath "$INSTDIR"
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
         
  File /r /x CVS ..\Docs

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\bibus.lnk" "$INSTDIR\bibusStart.pyw" "" "$INSTDIR\Pixmaps\bibus.ico"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk" "$INSTDIR\Docs\index.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\eTBlast.lnk" "$INSTDIR\Docs\html\en\eTBlast Interface to Bibus.htm"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\MSWord.lnk" "$INSTDIR\Docs\html\en\bibMSW.htm"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bibusStart.pyw"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  
; compiling python files
  nsExec::ExecToLog '"$PYTHON" -c "import sys,compileall; compileall.compile_dir(sys.argv[1])" "$INSTDIR"'
  nsExec::ExecToLog '"$PYTHON" -O -c "import sys,compileall; compileall.compile_dir(sys.argv[1])" "$INSTDIR"'
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "Main program"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Documentation english"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) a t dsinstall avec succs de votre ordinateur."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "tes-vous certains de vouloir dsinstaller totalement $(^Name) et tous ses composants ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  UserInfo::GetAccountType
  Pop $USER
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
    
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  
  StrCmp $USER "Admin" 0 +3
     SetShellVarContext all
     GoTo +2
     SetShellVarContext current
     
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\bibus.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\eTBlast.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\MSWord.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir /r "$INSTDIR"	; remove everything. We could be more clever by keeping a copy of the names of all the files.

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
