/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * mem_access.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: mem_access.c,v 1.1 2004/01/13 18:56:20 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <glib.h>

#include "mem_access.h"

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ----------------------- memory access macro ------------------------------ */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*****************************************************************************/
/* some CPU accepts to read word not aligned on a word boundary, other don't */
/*****************************************************************************/
#ifdef NO_UNALIGNED_ACCESS
/* bad luck, the CPU is very stupid */
guint16 get_unaligned_guint16(guint8 *addr)
{
	guint16 a,b;

	/* the &0xFF is not required because we work with unsigned values */
	a=((guint16)addr[0]);
	b=((guint16)addr[1]);
#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<8)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<8)|a;
#else
#error unsupported byte order
#endif
}

guint32 get_unaligned_guint32(guint8 *addr)
{
	guint32 a,b;

	/* the &0xFFFF is not required because we work with unsigned values */
	a=get_unaligned_guint16(addr);
	b=get_unaligned_guint16(addr+2);

#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<16)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<16)|a;
#else
#error unsupported byte order
#endif
}

guint64 get_unaligned_guint64(guint8 *addr)
{
	guint64 a,b;

	/* the &0xFFFF is not required because we work with unsigned values */
	a=get_unaligned_guint32(addr);
	b=get_unaligned_guint32(addr+4);

#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<32)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<32)|a;
#else
#error unsupported byte order
#endif
}

#endif

