/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * graph.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: graph.h,v 1.3 2004/01/10 16:16:34 ericprev Exp $
*/

#ifndef __GRAPH_H__
#define __GRAPH_H__

typedef enum
{
	GRAPH_BY_WEEKDAY,
	GRAPH_BY_MONTHDAY,
} GRAPH_TYPE;

typedef enum
{
	GRAPH_BY_TRANSFER,
	GRAPH_BY_SIZE,
} GRAPH_DISPLAY_TYPE;

typedef enum
{
	XFER_IS_DL,
	XFER_IS_UL,
} XFER_TYPE;

extern gint graph_image_w;
extern gint graph_image_h;
extern gint graph_depth;

extern GdkPixmap *graph_dl_image;
extern GRAPH_TYPE graph_dl_type;
extern GRAPH_DISPLAY_TYPE graph_dl_display_type;

extern GdkPixmap *graph_ul_image;
extern GRAPH_TYPE graph_ul_type;
extern GRAPH_DISPLAY_TYPE graph_ul_display_type;


/*****************************************************/
/* build a GdkImage containing the requested graphic */
/*****************************************************/
/* if w or h == -1, its value is left unchanged */
/************************************************/
void build_graph_image(gint w, gint h);

/*************************************/
/* clear the list of registered XFER */
/*************************************/
void graph_stat_clear(void);

/*************************************/
/* register a new XFER for the graph */
/*************************************/
void graph_stat_add(time_t end_time, guint64 size, XFER_TYPE xfer_type);

#endif
