/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * custom_hublist_tree.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: custom_hublist_tree.c,v 1.4 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <signal.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "custom_hublist_tree.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"

/*****************************************************************************************/
/* NOTE: the hidden_planar_hublist contains the same things as the hidden_planar_hublist */
/*       except each row is separated by a '\t'. The encoding remains the same           */
/*****************************************************************************************/

/*************************************************************************/
/* copy the hidden_planar_hublist entry from the custom_hublist_treeview */
/*************************************************************************/
void sync_custom_hublist_treeview_with_hidden_planar_hublist(void)
{
	GString *str;
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkTreeIter iter;
	gboolean valid;

	str=g_string_new("");

	w=get_widget_by_widget_name(main_window,"custom_hublist_treeview");
	gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w));
	valid=gtk_tree_model_get_iter_first(gtm,&iter);
	while(valid)
	{
		char *t;

		gtk_tree_model_get(gtm,&iter,CHT_URL_COL,&t,-1);
		if(t!=NULL)
		{
			if(str->len!=0)
				str=g_string_append_c(str,'\t');
		
			str=g_string_append(str,t);
			free(t);
		}

		valid=gtk_tree_model_iter_next(gtm,&iter);
	}

	w=get_widget_by_widget_name(main_window,"hidden_planar_hublist");
	if(w!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(w),str->str);
	}
	g_string_free(str,TRUE);
}

/***********************************************************************/
/* copy the hidden_planar_hublist entry to the custom_hublist_treeview */
/***********************************************************************/
void sync_hidden_planar_hublist_with_custom_hublist_treeview(void)
{
	GtkWidget *w;
	GtkListStore *gls;
	gchar **clist_entry;
	int i;

	w=get_widget_by_widget_name(main_window,"custom_hublist_treeview");
	gls=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(w)));
	gtk_list_store_clear(gls);

	{
		const char *t;
		t=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(main_window,"hidden_planar_hublist")));
		clist_entry=g_strsplit(t,"\t",0);
	}

	i=0;
	while(clist_entry[i]!=NULL)
	{
		GtkTreeIter iter;

		gtk_list_store_append(gls,&iter);
		gtk_list_store_set(gls,&iter,CHT_URL_COL,clist_entry[i],-1);
		i++;
	}

	g_strfreev(clist_entry);
}

#if 0
/*********************************************************************************************/
/* this function calls the given fnc for each selected entry of the "shared_dir_clist" clist */
/*********************************************************************************************/
void generic_selected_shared_dir_list_calls(GtkTreeSelectionForeachFunc fnc, void *data)
{
	GtkWidget *w;
	GtkTreeSelection *slc;

	w=get_widget_by_widget_name(main_window,"shared_dir_clist");
	if(w==NULL)
		return;

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(w));
	gtk_tree_selection_selected_foreach(slc,fnc,data);
}

#endif

/***********************************************************/
/* build modele and view for the custom_hublist_tree clist */
/***********************************************************/
void bmav4_custom_hublist_tree(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_CHT_COL, G_TYPE_STRING);

	view=get_widget_by_widget_name(main_window,"custom_hublist_treeview");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),FALSE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),CHT_URL_COL,"",rend,"text",CHT_URL_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}


