/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * hublist_converter.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hublist_converter.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __HUBLIST_CONVERTER_H__
#define __HUBLIST_CONVERTER_H__

typedef struct
{
	char hubname[96];
	int nb_users;
	char hubaddr[64];
	char hubdesc[128];

	/* for XML hublists */
	char country[48];					/* can be empty */
	unsigned long long shares;		/* 0 means undefined */
	char status[16];					/* can be empty */
	unsigned long long minshare;	/* 0 means undefined */
	unsigned int minslots;			/* 0 means undefined */
	unsigned int maxhub;				/* 0 means undefined */
	unsigned int maxusers;			/* 0 means undefined */
	float reliability;				/* <0 means undefined */
	int rating;							/* <0 means undefined */
} HUB_ENTRY;

/**************************************************************/
/* convert the output of 'hublist' into a GArray of HUB_ENTRY */
/**************************************************************/
/* hub addresses are uniq in the array */
/*************************************************/
/* The returned array must be free by the caller */
/*************************************************/
GArray *hublist_output_to_hub_entry_array(const char *hublist_output);

#endif
