/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * user_file_list_clist.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: user_file_list_clist.h,v 1.5 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __USER_FILE_LIST_CLIST_H__
#define __USER_FILE_LIST_CLIST_H__

typedef enum
{
	UFL_NICK_ROOT_ENTRY=0,		/* it is the root of the user file list */
	UFL_DIR_ENTRY,					/* it is a directory */
	UFL_FILE_ENTRY,				/* it is a file */
} USER_FILE_ENTRY_TYPE;

/************************************************************************/
/* for each selected entry, check if it does not have a selected parent */
/* an entry having a selected parent is unselected.                     */
/************************************************************************/
void keep_selected_lowest_user_file_list_nodes(void);

/*******************************************************************************************/
/* this function calls the given fnc for each selected entry of the "user_file_list" clist */
/*******************************************************************************************/
void generic_selected_user_file_list_calls(GtkTreeSelectionForeachFunc fnc, void *data);

/******************************************************************/
/* find the UFL_NICK_ROOT_ENTRY of a given entry (DIR|FILE)_ENTRY */
/*********************************************************************************/
/* output: FALSE if not found, TRUE if found and uninitialized outiter is filled */
/*********************************************************************************/
gboolean get_nick_entry_for_user_file_list_from_ufce(GtkTreeModel *gtm, GtkTreeIter *start_iter, GtkTreeIter *outiter);

/*************************************************************/
/* load the share list of a user in the user file list clist */
/*************************************************************/
void put_nick_ls_into_user_file_list_clist(char *nick);

/******************************************************/
/* build modele and view for the user file list clist */
/******************************************************/
void bmav4_user_file_list_clist(void);

#endif
