#!/usr/bin/env python
#
# Written by Bram Cohen
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: btcompletedir.py 335 2008-01-19 22:05:46Z camrdale-guest $

"""Make a metainfo (.dtorrent) file for every file in a directory.

Creates a new metainfo file for every file in a given directory.

"""

from DebTorrent import PSYCO
if PSYCO.psyco:
    try:
        import psyco
        assert psyco.__version__ >= 0x010100f0
        psyco.full()
    except:
        pass

from sys import argv, version_info, exit
assert version_info >= (2,3), "Install Python 2.3 or greater"
from os.path import split
from DebTorrent.BT1.makemetafile import defaults, completedir, print_announcelist_details
from DebTorrent.parseargs import parseargs, formatDefinitions
import logging

logging.basicConfig()
logger = logging.getLogger()

def prog(amount):
    """Display the current status of the file scan.
    
    @type amount: C{int}
    @param amount: the number of packages that have been found so far in the
        current file
    
    """
    
    print '%d packages found\r' % amount,
    
def next_file(file):
    """Print the name of the file being scanned.
    
    @type file: C{string}
    @param file: the file name
    
    """
    
    print "\nProcessing file: %s" % file
    
if len(argv) < 2:
    a,b = split(argv[0])
    print 'Usage: ' + b + ' <dir> [dir...] [params...]'
    print 'makes a .dtorrent file for every Packages file present in each dir.'
    print
    print formatDefinitions(defaults, 80)
    print_announcelist_details()
    print ('')
    exit(2)

try:
    config, args = parseargs(argv[1:], defaults, 1, None)
    for dir in args:
        completedir(dir, config, vc = prog, fc = next_file)
except ValueError, e:
    logger.exception(str(e))
    print 'error: ' + str(e)
    print 'run with no args for parameter explanations'
