#!/usr/bin/env python
#
# Written by Henry 'Pi' James
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: btrename.py 71 2007-05-29 05:58:07Z camrdale-guest $

"""Change the name field in a metainfo file.

Rename the directory that will be created (suggested) when the metainfo file's
download is started.

"""

from sys import *
from os.path import *
from sha import *
from DebTorrent.bencode import *

NAME, EXT = splitext(basename(argv[0]))
VERSION = '20021119'

print '%s %s - change the suggested filename in a .dtorrent file' % (NAME, VERSION)
print

if len(argv) != 3:
  print '%s file.dtorrent new.filename.ext' % argv[0]
  print
  exit(2) # common exit code for syntax error

metainfo_file = open(argv[1], 'rb')
metainfo = bdecode(metainfo_file.read())
metainfo_file.close()
print 'old filename: %s' % metainfo['name']
metainfo['name'] = argv[2]
print 'new filename: %s' % metainfo['name']
metainfo_file = open(argv[1], 'wb')
metainfo_file.write(bencode(metainfo))
metainfo_file.close
print
print 'done.'
print
