##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

import gtk
import Constants
import DSApp

class DlgAbout:
    """This class contains the implementation of the About dialog."""
    
    def __init__ (self):
        """Constructor of DlgAbout class."""

        # load dialog widget tree, get widgets and connect signals 
        dlg_about_widget_tree = gtk.glade.XML (Constants.RESOURCE_DIR + "/disksearch.glade", "dlg_about")
        self.dlg_about = dlg_about_widget_tree.get_widget ("dlg_about")
        dlg_about_widget_tree.signal_connect ("on_ok_clicked", self.about_dlg_close)

        img_appicon = dlg_about_widget_tree.get_widget ("img_appicon")
        img_appicon.set_from_pixbuf (DSApp.DSApp.view.pxb_appicon)
        
        self.dlg_about.set_icon (DSApp.DSApp.view.pxb_appicon)
        self.dlg_about.set_transient_for (DSApp.DSApp.view.app_disksearch)
        self.dlg_about.show ()

    def about_dlg_close (self, *args):
        """Closes the about dialog."""
        
        self.dlg_about.destroy ()
