<?php
# dvdisaster: English homepage translation
# Copyright (C) 2004-2010 Carsten Gnörlich
#
# UTF-8 trigger: äöüß 
#
# Include our PHP sub routines, then call begin_page()
# to start the HTML page, insert the header, 
# navigation and news if appropriate.

require("../include/dvdisaster.php");
require("../include/screenshot.php");
begin_page();

howto_headline("Создание файлов для исправления ошибок", "Основные настройки", "images/create-icon.png");
?>

<!--- Insert actual page content below --->

<?php begin_screen_shot("Открытие диалога настроек.","global-prefs-invoke.png"); ?>
<table><tr><td valign="top"><img src="../images/prefs-icon.png" valign="bottom"></td>
<td>В диалоге настройки имеются следующие вкладки.
Откройте диалог, выбрав значок, отмеченный зеленым на снимке с экрана
(для увеличения картинки нажмите на нее). Этот значок может выглядеть по-разному,
в зависимости от используемой темы.</td>
</tr></table>
<?php end_screen_shot(); ?>

<hr>

<a name="read"><b>Настройки для чтения образа с носителя</b></a><p>

<table width="100%" cellspacing="5">
<tr>
<td><img src="../images/good-image.png"></td>
<td>Если у вас уже есть ISO-образ, вы можете пропустить
две следующие вкладки и продолжить <a href="#ecc">настройки исправления ошибок</a>.
Но убедитесь, что у вас действительно имеется образ в формате ISO; другие форматы, например, ".nrg",
не дают пригодных данных для исправления ошибок.
</td>
</tr>
</table><p>

<?php begin_screen_shot("Вкладка \"Образ\".","create-prefs-image.png"); ?>
<b>Вкладка "Образ".</b> Убедитесь, что размер образа определяется с использованием
параметра "ISO/UDF", и что выбрана линейная стратегия чтения.
Требуемые настройки выделены зеленым. Оставьте остальные настройки стандартными.
<p>
<?php end_screen_shot(); ?>

<pre> </pre>

<?php begin_screen_shot("Вкладка \"Привод\".","create-prefs-drive.png"); ?>
<b>Вкладка "Привод".</b> Чтение данных с привода в то время, пока он раскручивается,
может приводить к ложным сообщениям об ошибках. Подрегулируйте время раскручивания для своего привода
(обычно 5-10 секунд) в поле, помеченном зеленым, чтобы dvdisaster выждал
соответствующее время.<p>
Оставьте остальные настройки с теми значениями, что показаны.<p>
<?php end_screen_shot(); ?>

<?php begin_screen_shot("\"Попытки чтения\".","create-prefs-read-attempts.png"); ?>
<b>"Попытки чтения".</b> Параметр "Чтение и анализ необработанных секторов" (помечено зеленым)
приводит к использованию дополнительной информации, предоставляемой приводом, для проверки целостности
читаемых данных. Эта настройка рекомендуется, так как мы заинтересованы в создании 
данных для исправления ошибок на основе правильно считанного образа.
С другой стороны, поскольку данные для коррекции ошибок могут быть созданы только с полностью
читаемых носителей, нам не требуется несколько попыток чтения и кэширование необработанных секторов,
как показывается на снимке с экрана.
<?php end_screen_shot(); ?>

<hr>

<a name="ecc"><b>Параметры исправления ошибок</b></a><p>

<?php begin_screen_shot("Вкладка \"Исправление ошибок\".","create-prefs-ecc.png"); ?>
<b>Вкладка "Исправление ошибок".</b> Сначала выберите "Файл для исправления ошибок (RS01)" в списке
"Хранить в:" (помечено зеленым). Выбирая избыточность, вы определите
максимальную способность исправления ошибок: файл для исправления ошибок
с избыточностью x% может исправить до x% ошибок чтения в оптимальных условиях.
Поскольку самый лучший случай обычно не встречается, вам следует добавить некоторый запас
избыточности, сделав один из следующих выборов (см. желтые пометки);

<ul>
<li>Фиксированные настройки "нормальная" и "высокая" дают избыточность в 14.3% и 33.5%
соответственно. Эти две уставки обеспечивают очень быстрое создание файлов для исправления
ошибок благодаря оптимизации программы.</li>
<li>Вы можете выбрать любую избыточность, активировав пункт "другая" и двигая
ползунок.</li>
<li>Активировав кнопку "Использовать не больше", можно задать размер файла для
исправления ошибок в МБ. dvdisaster выберет подходящую избыточность, чтобы
файл для исправления ошибок был близко, но не больше заданного размера.
</li>
</ul>

Избыточность тоже определяет размер файла для исправления ошибок;
использование избыточности x% приведет к созданию файла для исправления ошибок размером примерно x% размера
образа. Применение избыточности меньше "нормальной" (14.3%) не рекомендуется,
поскольку исправление ошибок может быть слишком быстро перегружено.
<?php end_screen_shot(); ?>

<?php begin_screen_shot("Вкладка \"Файлы\".","create-prefs-file.png"); ?>
<b>Вкладка "Файлы".</b> Если ваша операционная система не может создавать файлы больше 2ГБ,
то вы должны выбрать параметр "Разбить файлы" (помечено зеленым). 
В этом случае dvdisaster будет создавать
до 100 сегментов с именами "medium00.iso", "medium01.iso" и т.д. вместо
одного файла "medium.iso". Использование этой настройки приводит к небольшому снижению производительности.
Этот параметр полезен главным образом в Windows, если все еще используется старая файловая система FAT32.
Пока оставьте остальные параметры в выключенном состоянии; предложения по дальнейшей 
<a href="howtos25.php">оптимизации</a> идут дальше.
<?php end_screen_shot(); ?>

<pre> </pre>

<b>Не используемые вкладки</b><p>

На вкладке "Разное" в настоящее время есть только функции для создания
журнальных файлов. Это полезно для отправки <a href="feedback.php">отчетов об ошибках</a>,
но во время нормальной работы должно быть отключено.
Вкладка "Внешний вид" дает возможность подобрать по своему вкусу выходные цвета, 
но кроме этого она больше никак не влияет на создание данных для исправления ошибок.

<pre> </pre>

<a href="howtos23.php">Создание данных для исправления ошибок...</a>


<!--- do not change below --->

<?php
# end_page() adds the footer line and closes the HTML properly.

end_page();
?>
