#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <endian.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <asm/types.h>

#include "v4l.h"

#define QT_CLEAN_NAMESPACE
#include <qapp.h>

extern "C" {
#include <X11/Xlib.h>
#include <X11/extensions/xf86vmode.h>
}

int original_width=0;
int original_height=0;

bool setVidMode(int x, int y, int width, int height) {
	
	Display *dpy=qt_xdisplay();
	int screen=DefaultScreen(dpy);

	XF86VidModeModeInfo **modes;
	XF86VidModeModeLine current_mode;
	int current_dot_clock;
	int nb_modes;

	XF86VidModeGetAllModeLines(dpy, screen, &nb_modes, &modes);

	int i, j=-1;	
	for(i=0; i<nb_modes; i++) {
		if(modes[i]->hdisplay==width && modes[i]->vdisplay==height) j=i;
	}

	if(j!=-1) {
		XF86VidModeGetModeLine(dpy, screen, &current_dot_clock, &current_mode);
		original_width=current_mode.hdisplay;
		original_height=current_mode.vdisplay;
		if(original_width!=width || original_height!=height) {
			XF86VidModeLockModeSwitch(dpy, screen, 0);
			XF86VidModeSwitchToMode(dpy, screen, modes[j]);
			XF86VidModeSetViewPort(dpy, screen, x, y);
		}
	}

	for(i=0; i<nb_modes; i++) {
		if(modes[i]->privsize!=0)
#if defined(__cplusplus) || defined(c_plusplus)
			XFree(modes[i]->c_private);
#else
			XFree(modes[i]->private);
#endif
	}

	XFree(modes);
	
	if(j==-1) {
		return true;
	}
	
	return false;
}

void restoreOriginalVidMode() {
	if(original_width==0 || original_height==0) return;
	
	Display *dpy=qt_xdisplay();
	int screen=DefaultScreen(dpy);

	XF86VidModeModeInfo **modes;
	int nb_modes;

	XF86VidModeGetAllModeLines(dpy, screen, &nb_modes, &modes);

	int i, j=-1;	
	for(i=0; i<nb_modes; i++) {
		if(modes[i]->hdisplay==original_width && modes[i]->vdisplay==original_height) j=i;
	}

	if(j!=-1) {
		XF86VidModeLockModeSwitch(dpy, screen, 0);
		XF86VidModeSwitchToMode(dpy, screen, modes[j]);
	}

	for(i=0; i<nb_modes; i++) {
		if(modes[i]->privsize!=0)
#if defined(__cplusplus) || defined(c_plusplus)
			XFree(modes[i]->c_private);
#else
			XFree(modes[i]->private);
#endif
	}

	XFree(modes);
}
