#ifndef _ECS_CHAMP_DEF_H_
#define _ECS_CHAMP_DEF_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees a la structure `ecs_champ_t' decrivant un champ
 *   et propres aux champs principaux de type "definition"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2009 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_param_rc_glob.h"
#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui réalise le tri des types géométriques
 *  La fonction affiche le nombre d'éléments par type géométrique
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__trie_typ(ecs_champ_t  *this_champ_def,
                        int           dim_elt);


/*----------------------------------------------------------------------------
 *  Fonction qui construit
 *   les définitions des faces par décomposition des champs des cellules
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__decompose_cel(ecs_champ_t  *vect_champ_fac[],
                             ecs_champ_t  *champ_def_cel);


/*----------------------------------------------------------------------------
 *  Fonction qui realise la fusion des definitions des elements
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__int_fusionne(ecs_champ_t    *this_champ_def,
                            size_t         *nbr_elt_cpct,
                            ecs_tab_int_t  *signe_elt);


/*----------------------------------------------------------------------------
 *  Fonction qui realise la fusion des definitions des elements
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__real_fusionne(ecs_champ_t  *this_champ_def,
                             size_t       *nbr_elt_cpct);


/*----------------------------------------------------------------------------
 *  Fonction qui construit la liste des cellules attachées à une liste
 *  de faces fournie en argument.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__liste_cel_fac(const ecs_int_t       nbr_fac,
                             ecs_champ_t          *champ_def_cel,
                             const ecs_tab_int_t   liste_fac);


/*----------------------------------------------------------------------------
 *  Fonction qui construit un tableau de booleens conforme a une liste
 *   de sous-elements
 *  Un sous-element est a `true'
 *   s'il intervient dans la definition des elements
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__cree_masque(ecs_tab_bool_t   bool_sselt_select,
                           ecs_champ_t     *champ_def_elt);


/*----------------------------------------------------------------------------
 *  Suppression des sommets ne participant pas à la connectivité
 * (renvoie le champ de renumérotation des sommets, ou NULL si aucune
 * renumérotation n'a été nécessaire).
 *----------------------------------------------------------------------------*/

ecs_champ_t *
ecs_champ_def__nettoie_nodal(ecs_champ_t  *champ_def_som,
                             ecs_champ_t  *champ_def_fac,
                             ecs_champ_t  *champ_def_cel);


/*----------------------------------------------------------------------------
 *  Correction si nécessaire de l'orientation des éléments en connectivité
 *   nodale. Les arguments liste_cel_err et liste_cel_cor sont optionnels.
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__orient_nodal(ecs_champ_t    *champ_def_som,
                            ecs_champ_t    *champ_def_fac,
                            ecs_champ_t    *champ_def_cel,
                            ecs_tab_int_t  *liste_cel_err,
                            ecs_tab_int_t  *liste_cel_cor,
                            bool            correc_orient);


/*----------------------------------------------------------------------------
 *  Fusion des sommets confondus d'après la longueur des arêtes des faces.
 * La connectivité des faces est mise à jour.
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__nettoie_som_fac(ecs_champ_t   *champ_def_som,
                               ecs_champ_t   *champ_def_fac);


/*----------------------------------------------------------------------------
 *  Fonction qui supprime les éventuelles faces dégénérées
 *----------------------------------------------------------------------------*/

ecs_champ_t *
ecs_champ_def__nettoie_fac(ecs_champ_t  *champ_def_fac);


/*----------------------------------------------------------------------------
 *  Fonction qui calcule les coordonnées minimales et maximales
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__calc_coo_ext(ecs_champ_t  *champ_som_def);


/*----------------------------------------------------------------------------
 *  Fonction qui modifie les coordonnées du maillage
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__transf_coo(ecs_champ_t   *champ_som_def,
                          const double   matrice[3][4]);


/*----------------------------------------------------------------------------
 *  Fonction qui recolle les faces non conformes
 *
 *  Les listes des faces nouvelles ou modifiées sont construites (et allouées)
 *  ici ; les structures liste_fac_new et liste_fac_mod correspondantes sont
 *  donc vides en entrée ; idem pour liste_fac_err qui indiquera les indices
 *  des faces pour lesquelles le découpage en sous-faces a échoué
 *
 *  On prend en entrée soit une définition de type "visibilité" entre faces
 *  à recoller (par exemple une filiation), ou alors une simple liste de
 *  faces sélectionnées. L'un de vec_fac_vis et tab_fac_select doit donc
 *  être à NULL, et l'autre non.
 *----------------------------------------------------------------------------*/

void
ecs_champ_def__recolle(ecs_champ_t            *champ_def_fac,
                       ecs_champ_t            *champ_def_som,
                       ecs_champ_t           **champ_fac_old_new,
                       ecs_champ_t           **champ_fac_perio,
                       ecs_champ_t            *champ_fac_vis,
                       ecs_tab_int_t          *tab_fac_de_bord_select,
                       ecs_tab_int_t          *liste_fac_new,
                       ecs_tab_int_t          *liste_fac_mod,
                       ecs_tab_int_t          *liste_fac_err,
                       const ecs_param_rc_t    param_rc);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant un type à chaque face, sous
 * forme de masque : 0 pour face isolée, 1 ou 2 pour face de bord (1 si
 * cellule avec cette face normale sortante, 2 si cellule avec cette face
 * normale entrante), 1+2 = 3 pour face interne, et 4 ou plus pour tous
 * les autres cas, correspondant à une erreur de connectivité (+4 pour faces
 * voyant au moins deux cellules avec face normale sortante, +8 pour faces
 * voyant au moins deux cellules avec face normale entrante).
 *
 *  Le type de chaque face pourra être modifié ultérieurement en fonction
 * des informations de périodicité.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__typ_fac_cel(ecs_champ_t  *champ_def_cel,
                           ecs_champ_t  *champ_def_fac);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant un type à chaque face les
 * numéros des cellules définies par cette face (normale sortante,
 * puis normale entrante). On affecte une valeur 0 lorsqu'il n'y a pas de
 * cellule correspondante directe (la périodicité n'est donc pas prise en
 * compte à ce niveau).
 *
 * On suppose que la cohérence du maillage a déjà été véridifiée et
 * qu'aucune face n'appartient à plus d'une cellule par côté.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__fac_cel(ecs_champ_t  *champ_def_cel,
                       ecs_champ_t  *champ_def_fac);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant à chaque cellule un code
 * en fonction des erreurs de connectivité éventuelles associées à cette
 * cellule (0 si pas d'erreur, 1 si une des faces définissant cette cellule
 * s'appuie sur plusieurs cellules du même côté).
 *----------------------------------------------------------------------------*/

ecs_tab_int_t
ecs_champ_def__err_cel_connect(ecs_champ_t          *champ_def_cel,
                               const ecs_tab_int_t  *typ_fac_cel);


#endif /* _ECS_CHAMP_DEF_H_ */
