#ifndef _ECS_TAB_H_
#define _ECS_TAB_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associées à la structure `tab_t' décrivant un tableau
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/

#include <stdio.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui cree un tableau de dimension donnée
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_tab_int__cree
(
 size_t  dim_tab
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui crée un tableau de dimension donnée
 *   et initialise les valeurs avec une constante
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_tab_int__cree_init
(
 size_t      dim_tab,
 ecs_int_t   val_init
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui transforme le tableau donne en son inverse
 *----------------------------------------------------------------------------*/

void ecs_tab_int__inverse
(
 ecs_tab_int_t * this_tab
) ;


/*----------------------------------------------------------------------------
 *  Fonction de tri lexicographique d'un vecteur d'entiers.
 *
 *  La liste n'est pas modifiée directement,
 *   mais on construit un vecteur de renumérotation,
 *   afin de pouvoir appliquer cette renumérotation à d'autres tableaux
 *
 *  Le tri utilisé est de type "heapsort", de complexité O(nlog(n)).
 *  Les éléments sont rangés en ordre croissant.
 *----------------------------------------------------------------------------*/

void ecs_tab_int__trie
(
 const ecs_tab_int_t this_vect  ,          /* --> Vecteur des entiers a trier */
       ecs_tab_int_t vect_renum            /* <-- Vecteur de renumerotation   */
) ;


/*----------------------------------------------------------------------------
 *  Fonction de tri lexicographique d'un vecteur de chaînes de caractères
 *
 *  La liste n'est pas modifiée directement,
 *   mais on construit un vecteur de renumérotation,
 *   afin de pouvoir appliquer cette renumérotation à d'autres tableaux
 *
 *  Le tri utilisé est de type "heapsort", de complexité O(nlog(n)).
 *  Les éléments sont rangés en ordre croissant.
 *----------------------------------------------------------------------------*/

void ecs_tab_char__trie
(
 const ecs_tab_char_t this_vect  ,         /* --> Vecteur des entiers à trier */
       ecs_tab_int_t  vect_renum           /* <-- Vecteur de renumérotation   */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui trie un vecteur d'entiers donné
 *   en renvoyant le vecteur trié
 *
 *  La fonction détermine aussi le vecteur de renumérotation des indices
 *  (pour des indices commençant à `0')
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_tab_int__trie_et_renvoie
(
 const ecs_tab_int_t this_vect  ,          /* --> Vecteur des entiers a trier */
       ecs_tab_int_t vect_renum            /* <-- Vecteur de renumerotation   */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui trie un vecteur de chaînes de caractères donné
 *   en renvoyant le vecteur trié. Les chaînes ne sont pas dupliquées,
 *   seuls les pointeurs sont copiés.
 *
 *  La fonction détermine aussi le vecteur de renumérotation des indices
 *  (pour des indices commençant à `0')
 *----------------------------------------------------------------------------*/

ecs_tab_char_t ecs_tab_char__trie_et_renvoie
(
 const ecs_tab_char_t this_vect  ,         /* --> Vecteur des chaînes à trier */
       ecs_tab_int_t  vect_renum           /* <-- Vecteur de renumérotation   */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui compacte un vecteur de chaînes de caractères donné
 *   en renvoyant le vecteur compacté ; les chaînes ne sont pas dupliquées,
 *   seuls les pointeurs sont copiés.
 *
 *  Le vecteur d'origine doit être trié.
 *----------------------------------------------------------------------------*/

ecs_tab_char_t ecs_tab_char__compacte
(
 const ecs_tab_char_t this_vect        /* --> Vecteur des chaînes à compacter */
) ;


/*----------------------------------------------------------------------------
 *  Fonction de recherche d'une collection d'entiers
 *   dans une autre collection d'entiers strictement ordonnée.
 *   (Méthode de recherche dichotomique)
 *
 *  La fonction retourne un vecteur  d'indices correspondant
 *   à la position des entiers dans le vecteur ou est faite la recherche
 *  Si un entier n'est pas contenu dans le vecteur,
 *   on lui adresse un "indice" `-1'
 *----------------------------------------------------------------------------*/

void ecs_tab_int__recherche
(
 ecs_tab_int_t  this_vect_rec ,  /* Vecteur des entiers a rechercher          */
 ecs_tab_int_t       vect_ord ,  /* Vecteur ordonne ou est faite la recherche */
 ecs_tab_int_t       vect_ind
) ;


/*----------------------------------------------------------------------------
 *  Fonction de construction du tableau de remplacement référence -> indice
 *   Si bool_copie est à true, on alloue et on renvoie une copie de
 *   tab_att_reference, qui n'est pas modifié ; sinon, tab_att_reference est
 *   transformé.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_tab_int__ref_en_indice
(
       ecs_tab_int_t  tab_att_reference ,        /* <-> Valeurs a transformer */
 const ecs_tab_int_t  tab_val_idx       ,        /* <-> Valeurs de reference  */
       bool           bool_copie
) ;


#endif /* _ECS_TAB_H_ */
