/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009, 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "view_montage_dialog.h"





UI_ViewMontagewindow::UI_ViewMontagewindow(QWidget *parent)
{
  mainwindow = (UI_Mainwindow *)parent;

  mtg_path[0] = 0;
  mtg_dir[0] = 0;

  if(mainwindow->recent_montagedir[0]!=0)
  {
    strcpy(mtg_dir, mainwindow->recent_montagedir);
  }

  ViewMontageDialog = new QDialog;

  ViewMontageDialog->setMinimumSize(QSize(400, 300));
  ViewMontageDialog->resize(700, 440);
  ViewMontageDialog->setWindowTitle("View montage");
  ViewMontageDialog->setModal(TRUE);
  ViewMontageDialog->setAttribute(Qt::WA_DeleteOnClose, TRUE);

  textedit1 = new QTextEdit;
  textedit1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  textedit1->setReadOnly(TRUE);
  textedit1->setLineWrapMode(QTextEdit::NoWrap);
  textedit1->setFont(*mainwindow->monofont);

  SelectButton = new QPushButton;
  SelectButton->setFixedSize(100, 25);
  SelectButton->setText("Select montage");

  CloseButton = new QPushButton;
  CloseButton->setFixedSize(100, 25);
  CloseButton->setText("Close");

  hbox = new QHBoxLayout;
  hbox->addWidget(SelectButton, 0, Qt::AlignLeft);
  hbox->addWidget(CloseButton, 0, Qt::AlignRight);

  box = new QBoxLayout(QBoxLayout::TopToBottom, ViewMontageDialog);
  box->addWidget(textedit1);
  box->addLayout(hbox);

  QObject::connect(CloseButton,  SIGNAL(clicked()), ViewMontageDialog, SLOT(close()));
  QObject::connect(SelectButton, SIGNAL(clicked()), this,              SLOT(SelectButtonClicked()));

  ViewMontageDialog->exec();
}




void UI_ViewMontagewindow::SelectButtonClicked()
{
  int i,
      signalcomps_read=0,
      signals_read,
      signal_cnt,
      filters_read,
      color,
      filter_cnt,
      fidfilter_cnt=0,
      islpf,
      len,
      factor[MAXSIGNALS],
      signalcomps,
      screen_offset,
      order,
      model,
      type;

  char *result,
       composition_txt[2048],
       label[256];

  double frequency,
         frequency2,
         voltpercm,
         ripple;

  struct xml_handle *xml_hdl;

  QFileDialog fchooser;

  fchooser.setFileMode(QFileDialog::ExistingFile);
  fchooser.setAcceptMode(QFileDialog::AcceptOpen);
  fchooser.setWindowTitle("Choose a montage");
  fchooser.setLabelText(QFileDialog::FileName, "Name of montage:");
  fchooser.setDefaultSuffix("mtg");
#ifdef Q_WS_X11
  fchooser.setDirectory(getenv("HOME"));
#endif
#ifdef Q_WS_MAC
  fchooser.setDirectory(getenv("HOME"));
#endif
  fchooser.setFilter("Montage files (*.mtg *.MTG)");

  if(mtg_dir[0]!=0)
  {
    fchooser.setDirectory(mtg_dir);
  }

  if(!(fchooser.exec() == QDialog::Accepted))
  {
    return;
  }

  textedit1->clear();

  strcpy(mtg_path, fchooser.selectedFiles().at(0).toLatin1().data());

  strcpy(mtg_dir, mtg_path);
  len = strlen(mtg_dir);
  if(len)
  {
    for(i=len-1; i>=0; i--)
    {
      if((mtg_dir[i] == '/')||(mtg_dir[i] == '\\'))
      {
        break;
      }
    }
    mtg_dir[i+1] = 0;
  }

  xml_hdl = xml_get_handle(mtg_path);
  if(xml_hdl==NULL)
  {
    UI_Messagewindow popuperror("Error", "Error, can not open file for reading.");
    return;
  }

  if(strcmp(xml_hdl->elementname, PROGRAM_NAME "_montage"))
  {
    UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
    xml_close(xml_hdl);
    return;
  }

  ViewMontageDialog->setWindowTitle(mtg_path);

  textedit1->clear();

  for(signalcomps=0; ; signalcomps++)
  {
    xml_goto_root(xml_hdl);

    signals_read = 0;

    if(xml_goto_nth_element_inside(xml_hdl, "signalcomposition", signalcomps_read))
    {
      break;
    }

    if(xml_goto_nth_element_inside(xml_hdl, "num_of_signals", 0))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }
    result = xml_get_content_of_element(xml_hdl);
    signal_cnt = atoi(result);
    free(result);
    if((signal_cnt<1)||(signal_cnt>256))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }

    xml_go_up(xml_hdl);
    if(xml_goto_nth_element_inside(xml_hdl, "voltpercm", 0))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }
    result = xml_get_content_of_element(xml_hdl);
    voltpercm = atof(result);
    free(result);

    xml_go_up(xml_hdl);
    if(xml_goto_nth_element_inside(xml_hdl, "screen_offset", 0))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }
    result = xml_get_content_of_element(xml_hdl);
    screen_offset = atoi(result);
    free(result);

    xml_go_up(xml_hdl);
    if(xml_goto_nth_element_inside(xml_hdl, "color", 0))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }
    result = xml_get_content_of_element(xml_hdl);
    color = atoi(result);
    free(result);

    xml_go_up(xml_hdl);
    if(xml_goto_nth_element_inside(xml_hdl, "filter_cnt", 0))
    {
      UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
      xml_close(xml_hdl);
      return;
    }
    result = xml_get_content_of_element(xml_hdl);
    filter_cnt = atoi(result);
    free(result);

    xml_go_up(xml_hdl);
    if(!(xml_goto_nth_element_inside(xml_hdl, "fidfilter_cnt", 0)))
    {
      result = xml_get_content_of_element(xml_hdl);
      fidfilter_cnt = atoi(result);
      free(result);
    }

    sprintf(composition_txt, "%3i: ", signalcomps + 1);

    xml_go_up(xml_hdl);
    for(signals_read=0; signals_read<signal_cnt; signals_read++)
    {
      if(xml_goto_nth_element_inside(xml_hdl, "signal", signals_read))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
        xml_close(xml_hdl);
        return;
      }

      if(xml_goto_nth_element_inside(xml_hdl, "factor", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      factor[signals_read] = atoi(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "label", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file.");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      strcpy(label, result);
      free(result);

      sprintf(composition_txt + strlen(composition_txt), "%+ix %s", factor[signals_read], label);

      remove_trailing_spaces(composition_txt);

      strcat(composition_txt, " ");

      xml_go_up(xml_hdl);
      xml_go_up(xml_hdl);
    }

    for(filters_read=0; filters_read<filter_cnt; filters_read++)
    {
      if(xml_goto_nth_element_inside(xml_hdl, "filter", filters_read))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (filter)");
        xml_close(xml_hdl);
        return;
      }

      if(xml_goto_nth_element_inside(xml_hdl, "LPF", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (LPF)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      islpf = atoi(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "frequency", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (frequency)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      frequency = atof(result);
      free(result);

      if(islpf)
      {
        sprintf(composition_txt + strlen(composition_txt), "LPF: %fHz  ", frequency);
      }
      else
      {
        sprintf(composition_txt + strlen(composition_txt), "HPF: %fHz  ", frequency);
      }

      xml_go_up(xml_hdl);
      xml_go_up(xml_hdl);
    }

    for(filters_read=0; filters_read<fidfilter_cnt; filters_read++)
    {
      if(xml_goto_nth_element_inside(xml_hdl, "fidfilter", filters_read))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (fidfilter)");
        xml_close(xml_hdl);
        return;
      }

      if(xml_goto_nth_element_inside(xml_hdl, "type", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (type)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      type = atoi(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "frequency", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (frequency)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      frequency = atof(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "frequency2", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (frequency2)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      frequency2 = atof(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "ripple", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (ripple)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      ripple = atof(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "order", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (order)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      order = atoi(result);
      free(result);

      xml_go_up(xml_hdl);
      if(xml_goto_nth_element_inside(xml_hdl, "model", 0))
      {
        UI_Messagewindow popuperror("Error", "There seems to be an error in this montage file. (model)");
        xml_close(xml_hdl);
        return;
      }
      result = xml_get_content_of_element(xml_hdl);
      model = atoi(result);
      free(result);

      if(type == 0)
      {
        if(model == 0)
        {
          sprintf(composition_txt + strlen(composition_txt), "highpass Butterworth %fHz %ith order  ", frequency, order);
        }

        if(model == 1)
        {
          sprintf(composition_txt + strlen(composition_txt), "highpass Chebyshev %fHz %ith order %fdB ripple  ", frequency, order, ripple);
        }

        if(model == 2)
        {
          sprintf(composition_txt + strlen(composition_txt), "highpass Bessel %fHz %ith order  ", frequency, order);
        }
      }

      if(type == 1)
      {
        if(model == 0)
        {
          sprintf(composition_txt + strlen(composition_txt), "lowpass Butterworth %fHz %ith order  ", frequency, order);
        }

        if(model == 1)
        {
          sprintf(composition_txt + strlen(composition_txt), "lowpass Chebyshev %fHz %ith order %fdB ripple  ", frequency, order, ripple);
        }

        if(model == 2)
        {
          sprintf(composition_txt + strlen(composition_txt), "lowpass Bessel %fHz %ith order  ", frequency, order);
        }
      }

      if(type == 2)
      {
        sprintf(composition_txt + strlen(composition_txt), "notch %fHz Q-factor %i  ", frequency, order);
      }

      if(type == 3)
      {
        if(model == 0)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandpass Butterworth %f-%fHz %ith order  ", frequency, frequency2, order);
        }

        if(model == 1)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandpass Chebyshev %f-%fHz %ith order %fdB ripple  ", frequency, frequency2, order, ripple);
        }

        if(model == 2)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandpass Bessel %f-%fHz %ith order  ", frequency, frequency2, order);
        }
      }

      if(type == 4)
      {
        if(model == 0)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandstop Butterworth %f-%fHz %ith order  ", frequency, frequency2, order);
        }

        if(model == 1)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandstop Chebyshev %f-%fHz %ith order %fdB ripple  ", frequency, frequency2, order, ripple);
        }

        if(model == 2)
        {
          sprintf(composition_txt + strlen(composition_txt), "bandstop Bessel %f-%fHz %ith order  ", frequency, frequency2, order);
        }
      }

      xml_go_up(xml_hdl);
      xml_go_up(xml_hdl);
    }

    sprintf(composition_txt + strlen(composition_txt), " %f/cm  offset: %f", voltpercm, (double)screen_offset * mainwindow->pixelsizefactor * voltpercm);

    remove_trailing_zeros(composition_txt);

    textedit1->append(composition_txt);

    signalcomps_read++;
  }

  xml_close(xml_hdl);
}













